// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.waiters

import aws.sdk.kotlin.services.codegurureviewer.CodeGuruReviewerClient
import aws.sdk.kotlin.services.codegurureviewer.model.DescribeCodeReviewRequest
import aws.sdk.kotlin.services.codegurureviewer.model.DescribeCodeReviewResponse
import aws.sdk.kotlin.services.codegurureviewer.model.DescribeRepositoryAssociationRequest
import aws.sdk.kotlin.services.codegurureviewer.model.DescribeRepositoryAssociationResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until a code review is complete.
 */
public suspend fun CodeGuruReviewerClient.waitUntilCodeReviewCompleted(request: DescribeCodeReviewRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeCodeReviewResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 10_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeCodeReviewRequest, DescribeCodeReviewResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val codeReview = it.codeReview
            val state = codeReview?.state?.value
            state == "Completed"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val codeReview = it.codeReview
            val state = codeReview?.state?.value
            state == "Failed"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val codeReview = it.codeReview
            val state = codeReview?.state?.value
            state == "Pending"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeCodeReview(request) }
}

/**
 * Wait until a code review is complete.
 */
public suspend fun CodeGuruReviewerClient.waitUntilCodeReviewCompleted(block: DescribeCodeReviewRequest.Builder.() -> Unit): Outcome<DescribeCodeReviewResponse> =
    waitUntilCodeReviewCompleted(DescribeCodeReviewRequest.Builder().apply(block).build())

/**
 * Wait until a repository association is complete.
 */
public suspend fun CodeGuruReviewerClient.waitUntilRepositoryAssociationSucceeded(request: DescribeRepositoryAssociationRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeRepositoryAssociationResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 10_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeRepositoryAssociationRequest, DescribeRepositoryAssociationResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val repositoryAssociation = it.repositoryAssociation
            val state = repositoryAssociation?.state?.value
            state == "Associated"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val repositoryAssociation = it.repositoryAssociation
            val state = repositoryAssociation?.state?.value
            state == "Failed"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val repositoryAssociation = it.repositoryAssociation
            val state = repositoryAssociation?.state?.value
            state == "Associating"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeRepositoryAssociation(request) }
}

/**
 * Wait until a repository association is complete.
 */
public suspend fun CodeGuruReviewerClient.waitUntilRepositoryAssociationSucceeded(block: DescribeRepositoryAssociationRequest.Builder.() -> Unit): Outcome<DescribeRepositoryAssociationResponse> =
    waitUntilRepositoryAssociationSucceeded(DescribeRepositoryAssociationRequest.Builder().apply(block).build())
