// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information about a repository association. The [ListRepositoryAssociations](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html) operation returns a list of `RepositoryAssociationSummary` objects.
 */
public class RepositoryAssociationSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the [RepositoryAssociation](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html) object. You can retrieve this ARN by calling [ListRepositoryAssociations](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html).
     */
    public val associationArn: kotlin.String? = builder.associationArn
    /**
     * The repository association ID.
     */
    public val associationId: kotlin.String? = builder.associationId
    /**
     * The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is `arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id`. For more information, see [Connection](https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html) in the *Amazon Web Services CodeStar Connections API Reference*.
     */
    public val connectionArn: kotlin.String? = builder.connectionArn
    /**
     * The time, in milliseconds since the epoch, since the repository association was last updated.
     */
    public val lastUpdatedTimeStamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTimeStamp
    /**
     * The name of the repository association.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository. For an S3 repository, it can be the username or Amazon Web Services account ID.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * The provider type of the repository association.
     */
    public val providerType: aws.sdk.kotlin.services.codegurureviewer.model.ProviderType? = builder.providerType
    /**
     * The state of the repository association.
     *
     * The valid repository association states are:
     * + **Associated**: The repository association is complete.
     * + **Associating**: CodeGuru Reviewer is:
     *    + Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru Reviewer review.If your repository `ProviderType` is `GitHub`, `GitHub Enterprise Server`, or `Bitbucket`, CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks, reviews of code in your repository cannot be triggered.
     *    + Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your repository.
     * + **Failed**: The repository failed to associate or disassociate.
     * + **Disassociating**: CodeGuru Reviewer is removing the repository's pull request notifications and source code access.
     * + **Disassociated**: CodeGuru Reviewer successfully disassociated the repository. You can create a new association with this repository if you want to review source code in it later. You can control access to code reviews created in anassociated repository with tags after it has been disassociated. For more information, see [Using tags to control access to associated repositories](https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html) in the *Amazon CodeGuru Reviewer User Guide*.
     */
    public val state: aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAssociationState? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAssociationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RepositoryAssociationSummary(")
        append("associationArn=$associationArn,")
        append("associationId=$associationId,")
        append("connectionArn=$connectionArn,")
        append("lastUpdatedTimeStamp=$lastUpdatedTimeStamp,")
        append("name=$name,")
        append("owner=$owner,")
        append("providerType=$providerType,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationArn?.hashCode() ?: 0
        result = 31 * result + (associationId?.hashCode() ?: 0)
        result = 31 * result + (connectionArn?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimeStamp?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (providerType?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RepositoryAssociationSummary

        if (associationArn != other.associationArn) return false
        if (associationId != other.associationId) return false
        if (connectionArn != other.connectionArn) return false
        if (lastUpdatedTimeStamp != other.lastUpdatedTimeStamp) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (providerType != other.providerType) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAssociationSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the [RepositoryAssociation](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html) object. You can retrieve this ARN by calling [ListRepositoryAssociations](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html).
         */
        public var associationArn: kotlin.String? = null
        /**
         * The repository association ID.
         */
        public var associationId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an Amazon Web Services CodeStar Connections connection. Its format is `arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id`. For more information, see [Connection](https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html) in the *Amazon Web Services CodeStar Connections API Reference*.
         */
        public var connectionArn: kotlin.String? = null
        /**
         * The time, in milliseconds since the epoch, since the repository association was last updated.
         */
        public var lastUpdatedTimeStamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the repository association.
         */
        public var name: kotlin.String? = null
        /**
         * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository. For an S3 repository, it can be the username or Amazon Web Services account ID.
         */
        public var owner: kotlin.String? = null
        /**
         * The provider type of the repository association.
         */
        public var providerType: aws.sdk.kotlin.services.codegurureviewer.model.ProviderType? = null
        /**
         * The state of the repository association.
         *
         * The valid repository association states are:
         * + **Associated**: The repository association is complete.
         * + **Associating**: CodeGuru Reviewer is:
         *    + Setting up pull request notifications. This is required for pull requests to trigger a CodeGuru Reviewer review.If your repository `ProviderType` is `GitHub`, `GitHub Enterprise Server`, or `Bitbucket`, CodeGuru Reviewer creates webhooks in your repository to trigger CodeGuru Reviewer reviews. If you delete these webhooks, reviews of code in your repository cannot be triggered.
         *    + Setting up source code access. This is required for CodeGuru Reviewer to securely clone code in your repository.
         * + **Failed**: The repository failed to associate or disassociate.
         * + **Disassociating**: CodeGuru Reviewer is removing the repository's pull request notifications and source code access.
         * + **Disassociated**: CodeGuru Reviewer successfully disassociated the repository. You can create a new association with this repository if you want to review source code in it later. You can control access to code reviews created in anassociated repository with tags after it has been disassociated. For more information, see [Using tags to control access to associated repositories](https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html) in the *Amazon CodeGuru Reviewer User Guide*.
         */
        public var state: aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAssociationState? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAssociationSummary) : this() {
            this.associationArn = x.associationArn
            this.associationId = x.associationId
            this.connectionArn = x.connectionArn
            this.lastUpdatedTimeStamp = x.lastUpdatedTimeStamp
            this.name = x.name
            this.owner = x.owner
            this.providerType = x.providerType
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAssociationSummary = RepositoryAssociationSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
