// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model

import aws.smithy.kotlin.runtime.SdkDsl

public class AssociateRepositoryRequest private constructor(builder: Builder) {
    /**
     * Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate repository associations if there are failures and retries.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * A `KMSKeyDetails` object that contains:
     * + The encryption option for this repository association. It is either owned by Amazon Web Services Key Management Service (KMS) (`AWS_OWNED_CMK`) or customer managed (`CUSTOMER_MANAGED_CMK`).
     * + The ID of the Amazon Web Services KMS key that is associated with this repository association.
     */
    public val kmsKeyDetails: aws.sdk.kotlin.services.codegurureviewer.model.KmsKeyDetails? = builder.kmsKeyDetails
    /**
     * The repository to associate.
     */
    public val repository: aws.sdk.kotlin.services.codegurureviewer.model.Repository? = builder.repository
    /**
     * An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts:
     * + A *tag key* (for example, `CostCenter`, `Environment`, `Project`, or `Secret`). Tag keys are case sensitive.
     * + An optional field known as a *tag value* (for example, `111122223333`, `Production`, or a team name). Omitting the tag value is the same as using an empty string. Like tag keys, tag values are case sensitive.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.AssociateRepositoryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssociateRepositoryRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("kmsKeyDetails=$kmsKeyDetails,")
        append("repository=$repository,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (kmsKeyDetails?.hashCode() ?: 0)
        result = 31 * result + (repository?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssociateRepositoryRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (kmsKeyDetails != other.kmsKeyDetails) return false
        if (repository != other.repository) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.AssociateRepositoryRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon CodeGuru Reviewer uses this value to prevent the accidental creation of duplicate repository associations if there are failures and retries.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * A `KMSKeyDetails` object that contains:
         * + The encryption option for this repository association. It is either owned by Amazon Web Services Key Management Service (KMS) (`AWS_OWNED_CMK`) or customer managed (`CUSTOMER_MANAGED_CMK`).
         * + The ID of the Amazon Web Services KMS key that is associated with this repository association.
         */
        public var kmsKeyDetails: aws.sdk.kotlin.services.codegurureviewer.model.KmsKeyDetails? = null
        /**
         * The repository to associate.
         */
        public var repository: aws.sdk.kotlin.services.codegurureviewer.model.Repository? = null
        /**
         * An array of key-value pairs used to tag an associated repository. A tag is a custom attribute label with two parts:
         * + A *tag key* (for example, `CostCenter`, `Environment`, `Project`, or `Secret`). Tag keys are case sensitive.
         * + An optional field known as a *tag value* (for example, `111122223333`, `Production`, or a team name). Omitting the tag value is the same as using an empty string. Like tag keys, tag values are case sensitive.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.AssociateRepositoryRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.kmsKeyDetails = x.kmsKeyDetails
            this.repository = x.repository
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.AssociateRepositoryRequest = AssociateRepositoryRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.KmsKeyDetails] inside the given [block]
         */
        public fun kmsKeyDetails(block: aws.sdk.kotlin.services.codegurureviewer.model.KmsKeyDetails.Builder.() -> kotlin.Unit) {
            this.kmsKeyDetails = aws.sdk.kotlin.services.codegurureviewer.model.KmsKeyDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.Repository] inside the given [block]
         */
        public fun repository(block: aws.sdk.kotlin.services.codegurureviewer.model.Repository.Builder.() -> kotlin.Unit) {
            this.repository = aws.sdk.kotlin.services.codegurureviewer.model.Repository.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
