// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Metadata that is associated with a code review. This applies to both pull request and repository analysis code reviews.
 */
public class RequestMetadata private constructor(builder: Builder) {
    /**
     * Information about the event associated with a code review.
     */
    public val eventInfo: aws.sdk.kotlin.services.codegurureviewer.model.EventInfo? = builder.eventInfo
    /**
     * The ID of the request. This is required for a pull request code review.
     */
    public val requestId: kotlin.String? = builder.requestId
    /**
     * An identifier, such as a name or account ID, that is associated with the requester. The `Requester` is used to capture the `author/actor` name of the event request.
     */
    public val requester: kotlin.String? = builder.requester
    /**
     * The name of the repository vendor used to upload code to an S3 bucket for a CI/CD code review. For example, if code and artifacts are uploaded to an S3 bucket for a CI/CD code review by GitHub scripts from a GitHub repository, then the repository association's `ProviderType` is `S3Bucket` and the CI/CD repository vendor name is GitHub. For more information, see the definition for `ProviderType` in [RepositoryAssociation](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html).
     */
    public val vendorName: aws.sdk.kotlin.services.codegurureviewer.model.VendorName? = builder.vendorName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.RequestMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RequestMetadata(")
        append("eventInfo=$eventInfo,")
        append("requestId=$requestId,")
        append("requester=$requester,")
        append("vendorName=$vendorName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventInfo?.hashCode() ?: 0
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (requester?.hashCode() ?: 0)
        result = 31 * result + (vendorName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RequestMetadata

        if (eventInfo != other.eventInfo) return false
        if (requestId != other.requestId) return false
        if (requester != other.requester) return false
        if (vendorName != other.vendorName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.RequestMetadata = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Information about the event associated with a code review.
         */
        public var eventInfo: aws.sdk.kotlin.services.codegurureviewer.model.EventInfo? = null
        /**
         * The ID of the request. This is required for a pull request code review.
         */
        public var requestId: kotlin.String? = null
        /**
         * An identifier, such as a name or account ID, that is associated with the requester. The `Requester` is used to capture the `author/actor` name of the event request.
         */
        public var requester: kotlin.String? = null
        /**
         * The name of the repository vendor used to upload code to an S3 bucket for a CI/CD code review. For example, if code and artifacts are uploaded to an S3 bucket for a CI/CD code review by GitHub scripts from a GitHub repository, then the repository association's `ProviderType` is `S3Bucket` and the CI/CD repository vendor name is GitHub. For more information, see the definition for `ProviderType` in [RepositoryAssociation](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html).
         */
        public var vendorName: aws.sdk.kotlin.services.codegurureviewer.model.VendorName? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.RequestMetadata) : this() {
            this.eventInfo = x.eventInfo
            this.requestId = x.requestId
            this.requester = x.requester
            this.vendorName = x.vendorName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.RequestMetadata = RequestMetadata(this)

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.EventInfo] inside the given [block]
         */
        public fun eventInfo(block: aws.sdk.kotlin.services.codegurureviewer.model.EventInfo.Builder.() -> kotlin.Unit) {
            this.eventInfo = aws.sdk.kotlin.services.codegurureviewer.model.EventInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
