// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The type of a code review. There are two code review types:
 * + `PullRequest` - A code review that is automatically triggered by a pull request on an associated repository.
 * + `RepositoryAnalysis` - A code review that analyzes all code under a specified branch in an associated repository. The associated repository is specified using its ARN in [CreateCodeReview](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview).
 */
public class CodeReviewType private constructor(builder: Builder) {
    /**
     * They types of analysis performed during a repository analysis or a pull request review. You can specify either `Security`, `CodeQuality`, or both.
     */
    public val analysisTypes: List<AnalysisType>? = builder.analysisTypes
    /**
     * A code review that analyzes all code under a specified branch in an associated repository. The associated repository is specified using its ARN in [CreateCodeReview](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview).
     */
    public val repositoryAnalysis: aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAnalysis? = builder.repositoryAnalysis

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.CodeReviewType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CodeReviewType(")
        append("analysisTypes=$analysisTypes,")
        append("repositoryAnalysis=$repositoryAnalysis")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisTypes?.hashCode() ?: 0
        result = 31 * result + (repositoryAnalysis?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CodeReviewType

        if (analysisTypes != other.analysisTypes) return false
        if (repositoryAnalysis != other.repositoryAnalysis) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.CodeReviewType = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * They types of analysis performed during a repository analysis or a pull request review. You can specify either `Security`, `CodeQuality`, or both.
         */
        public var analysisTypes: List<AnalysisType>? = null
        /**
         * A code review that analyzes all code under a specified branch in an associated repository. The associated repository is specified using its ARN in [CreateCodeReview](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview).
         */
        public var repositoryAnalysis: aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAnalysis? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.CodeReviewType) : this() {
            this.analysisTypes = x.analysisTypes
            this.repositoryAnalysis = x.repositoryAnalysis
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.CodeReviewType = CodeReviewType(this)

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAnalysis] inside the given [block]
         */
        public fun repositoryAnalysis(block: aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAnalysis.Builder.() -> kotlin.Unit) {
            this.repositoryAnalysis = aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAnalysis.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
