// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * A code review type that analyzes all code under a specified branch in an associated repository. The associated repository is specified using its ARN when you call [CreateCodeReview](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CreateCodeReview).
 */
public class RepositoryAnalysis private constructor(builder: Builder) {
    /**
     * A [SourceCodeType](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType) that specifies the tip of a branch in an associated repository.
     */
    public val repositoryHead: aws.sdk.kotlin.services.codegurureviewer.model.RepositoryHeadSourceCodeType? = builder.repositoryHead
    /**
     * Specifies the source code that is analyzed in a code review.
     */
    public val sourceCodeType: aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType? = builder.sourceCodeType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAnalysis = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RepositoryAnalysis(")
        append("repositoryHead=$repositoryHead,")
        append("sourceCodeType=$sourceCodeType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = repositoryHead?.hashCode() ?: 0
        result = 31 * result + (sourceCodeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RepositoryAnalysis

        if (repositoryHead != other.repositoryHead) return false
        if (sourceCodeType != other.sourceCodeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAnalysis = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A [SourceCodeType](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType) that specifies the tip of a branch in an associated repository.
         */
        public var repositoryHead: aws.sdk.kotlin.services.codegurureviewer.model.RepositoryHeadSourceCodeType? = null
        /**
         * Specifies the source code that is analyzed in a code review.
         */
        public var sourceCodeType: aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAnalysis) : this() {
            this.repositoryHead = x.repositoryHead
            this.sourceCodeType = x.sourceCodeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.RepositoryAnalysis = RepositoryAnalysis(this)

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.RepositoryHeadSourceCodeType] inside the given [block]
         */
        public fun repositoryHead(block: aws.sdk.kotlin.services.codegurureviewer.model.RepositoryHeadSourceCodeType.Builder.() -> kotlin.Unit) {
            this.repositoryHead = aws.sdk.kotlin.services.codegurureviewer.model.RepositoryHeadSourceCodeType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType] inside the given [block]
         */
        public fun sourceCodeType(block: aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType.Builder.() -> kotlin.Unit) {
            this.sourceCodeType = aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
