// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * Information about recommendations.
 */
public class RecommendationSummary private constructor(builder: Builder) {
    /**
     * A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the start line and the end line.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Last line where the recommendation is applicable in the source commit or source branch. For a single line comment the start line and end line values are the same.
     */
    public val endLine: kotlin.Int? = builder.endLine
    /**
     * Name of the file on which a recommendation is provided.
     */
    public val filePath: kotlin.String? = builder.filePath
    /**
     * The type of a recommendation.
     */
    public val recommendationCategory: aws.sdk.kotlin.services.codegurureviewer.model.RecommendationCategory? = builder.recommendationCategory
    /**
     * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
     */
    public val recommendationId: kotlin.String? = builder.recommendationId
    /**
     * Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a short and long description. CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is included in analysis results if code is detected that violates the rule.
     */
    public val ruleMetadata: aws.sdk.kotlin.services.codegurureviewer.model.RuleMetadata? = builder.ruleMetadata
    /**
     * The severity of the issue in the code that generated this recommendation.
     */
    public val severity: aws.sdk.kotlin.services.codegurureviewer.model.Severity? = builder.severity
    /**
     * Start line from where the recommendation is applicable in the source commit or source branch.
     */
    public val startLine: kotlin.Int? = builder.startLine

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.RecommendationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendationSummary(")
        append("description=$description,")
        append("endLine=$endLine,")
        append("filePath=$filePath,")
        append("recommendationCategory=$recommendationCategory,")
        append("recommendationId=$recommendationId,")
        append("ruleMetadata=$ruleMetadata,")
        append("severity=$severity,")
        append("startLine=$startLine")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (endLine ?: 0)
        result = 31 * result + (filePath?.hashCode() ?: 0)
        result = 31 * result + (recommendationCategory?.hashCode() ?: 0)
        result = 31 * result + (recommendationId?.hashCode() ?: 0)
        result = 31 * result + (ruleMetadata?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (startLine ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommendationSummary

        if (description != other.description) return false
        if (endLine != other.endLine) return false
        if (filePath != other.filePath) return false
        if (recommendationCategory != other.recommendationCategory) return false
        if (recommendationId != other.recommendationId) return false
        if (ruleMetadata != other.ruleMetadata) return false
        if (severity != other.severity) return false
        if (startLine != other.startLine) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.RecommendationSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A description of the recommendation generated by CodeGuru Reviewer for the lines of code between the start line and the end line.
         */
        public var description: kotlin.String? = null
        /**
         * Last line where the recommendation is applicable in the source commit or source branch. For a single line comment the start line and end line values are the same.
         */
        public var endLine: kotlin.Int? = null
        /**
         * Name of the file on which a recommendation is provided.
         */
        public var filePath: kotlin.String? = null
        /**
         * The type of a recommendation.
         */
        public var recommendationCategory: aws.sdk.kotlin.services.codegurureviewer.model.RecommendationCategory? = null
        /**
         * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
         */
        public var recommendationId: kotlin.String? = null
        /**
         * Metadata about a rule. Rule metadata includes an ID, a name, a list of tags, and a short and long description. CodeGuru Reviewer uses rules to analyze code. A rule's recommendation is included in analysis results if code is detected that violates the rule.
         */
        public var ruleMetadata: aws.sdk.kotlin.services.codegurureviewer.model.RuleMetadata? = null
        /**
         * The severity of the issue in the code that generated this recommendation.
         */
        public var severity: aws.sdk.kotlin.services.codegurureviewer.model.Severity? = null
        /**
         * Start line from where the recommendation is applicable in the source commit or source branch.
         */
        public var startLine: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.RecommendationSummary) : this() {
            this.description = x.description
            this.endLine = x.endLine
            this.filePath = x.filePath
            this.recommendationCategory = x.recommendationCategory
            this.recommendationId = x.recommendationId
            this.ruleMetadata = x.ruleMetadata
            this.severity = x.severity
            this.startLine = x.startLine
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.RecommendationSummary = RecommendationSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.RuleMetadata] inside the given [block]
         */
        public fun ruleMetadata(block: aws.sdk.kotlin.services.codegurureviewer.model.RuleMetadata.Builder.() -> kotlin.Unit) {
            this.ruleMetadata = aws.sdk.kotlin.services.codegurureviewer.model.RuleMetadata.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
