// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the recommendation feedback.
 */
public class RecommendationFeedback private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the [CodeReview](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html) object.
     */
    public val codeReviewArn: kotlin.String? = builder.codeReviewArn
    /**
     * The time at which the feedback was created.
     */
    public val createdTimeStamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimeStamp
    /**
     * The time at which the feedback was last updated.
     */
    public val lastUpdatedTimeStamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTimeStamp
    /**
     * List for storing reactions. Reactions are utf-8 text code for emojis. You can send an empty list to clear off all your feedback.
     */
    public val reactions: List<Reaction>? = builder.reactions
    /**
     * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
     */
    public val recommendationId: kotlin.String? = builder.recommendationId
    /**
     * The ID of the user that made the API call.
     *
     *  The `UserId` is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For more information, see [ Specifying a Principal](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying) in the *Amazon Web Services Identity and Access Management User Guide*.
     */
    public val userId: kotlin.String? = builder.userId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.RecommendationFeedback = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendationFeedback(")
        append("codeReviewArn=$codeReviewArn,")
        append("createdTimeStamp=$createdTimeStamp,")
        append("lastUpdatedTimeStamp=$lastUpdatedTimeStamp,")
        append("reactions=$reactions,")
        append("recommendationId=$recommendationId,")
        append("userId=$userId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = codeReviewArn?.hashCode() ?: 0
        result = 31 * result + (createdTimeStamp?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimeStamp?.hashCode() ?: 0)
        result = 31 * result + (reactions?.hashCode() ?: 0)
        result = 31 * result + (recommendationId?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommendationFeedback

        if (codeReviewArn != other.codeReviewArn) return false
        if (createdTimeStamp != other.createdTimeStamp) return false
        if (lastUpdatedTimeStamp != other.lastUpdatedTimeStamp) return false
        if (reactions != other.reactions) return false
        if (recommendationId != other.recommendationId) return false
        if (userId != other.userId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.RecommendationFeedback = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the [CodeReview](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html) object.
         */
        public var codeReviewArn: kotlin.String? = null
        /**
         * The time at which the feedback was created.
         */
        public var createdTimeStamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time at which the feedback was last updated.
         */
        public var lastUpdatedTimeStamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * List for storing reactions. Reactions are utf-8 text code for emojis. You can send an empty list to clear off all your feedback.
         */
        public var reactions: List<Reaction>? = null
        /**
         * The recommendation ID that can be used to track the provided recommendations. Later on it can be used to collect the feedback.
         */
        public var recommendationId: kotlin.String? = null
        /**
         * The ID of the user that made the API call.
         *
         *  The `UserId` is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For more information, see [ Specifying a Principal](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying) in the *Amazon Web Services Identity and Access Management User Guide*.
         */
        public var userId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.RecommendationFeedback) : this() {
            this.codeReviewArn = x.codeReviewArn
            this.createdTimeStamp = x.createdTimeStamp
            this.lastUpdatedTimeStamp = x.lastUpdatedTimeStamp
            this.reactions = x.reactions
            this.recommendationId = x.recommendationId
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.RecommendationFeedback = RecommendationFeedback(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
