// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



public class ListRecommendationFeedbackRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the [CodeReview](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html) object.
     */
    public val codeReviewArn: kotlin.String? = builder.codeReviewArn
    /**
     * The maximum number of results that are returned per call. The default is 100.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Used to query the recommendation feedback for a given recommendation.
     */
    public val recommendationIds: List<String>? = builder.recommendationIds
    /**
     * An Amazon Web Services user's account ID or Amazon Resource Name (ARN). Use this ID to query the recommendation feedback for a code review from that user.
     *
     *  The `UserId` is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For more information, see [ Specifying a Principal](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying) in the *Amazon Web Services Identity and Access Management User Guide*.
     */
    public val userIds: List<String>? = builder.userIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.ListRecommendationFeedbackRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListRecommendationFeedbackRequest(")
        append("codeReviewArn=$codeReviewArn,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("recommendationIds=$recommendationIds,")
        append("userIds=$userIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = codeReviewArn?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (recommendationIds?.hashCode() ?: 0)
        result = 31 * result + (userIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListRecommendationFeedbackRequest

        if (codeReviewArn != other.codeReviewArn) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (recommendationIds != other.recommendationIds) return false
        if (userIds != other.userIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.ListRecommendationFeedbackRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the [CodeReview](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html) object.
         */
        public var codeReviewArn: kotlin.String? = null
        /**
         * The maximum number of results that are returned per call. The default is 100.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Used to query the recommendation feedback for a given recommendation.
         */
        public var recommendationIds: List<String>? = null
        /**
         * An Amazon Web Services user's account ID or Amazon Resource Name (ARN). Use this ID to query the recommendation feedback for a code review from that user.
         *
         *  The `UserId` is an IAM principal that can be specified as an Amazon Web Services account ID or an Amazon Resource Name (ARN). For more information, see [ Specifying a Principal](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#Principal_specifying) in the *Amazon Web Services Identity and Access Management User Guide*.
         */
        public var userIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.ListRecommendationFeedbackRequest) : this() {
            this.codeReviewArn = x.codeReviewArn
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.recommendationIds = x.recommendationIds
            this.userIds = x.userIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.ListRecommendationFeedbackRequest = ListRecommendationFeedbackRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
