// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model



/**
 * A type of [SourceCodeType](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType) that specifies the commit diff for a pull request on an associated repository. The `SourceCommit` and `DestinationCommit` fields are required to do a pull request code review.
 */
public class CommitDiffSourceCodeType private constructor(builder: Builder) {
    /**
     * The SHA of the destination commit used to generate a commit diff. This field is required for a pull request code review.
     */
    public val destinationCommit: kotlin.String? = builder.destinationCommit
    /**
     * The SHA of the merge base of a commit.
     */
    public val mergeBaseCommit: kotlin.String? = builder.mergeBaseCommit
    /**
     * The SHA of the source commit used to generate a commit diff. This field is required for a pull request code review.
     */
    public val sourceCommit: kotlin.String? = builder.sourceCommit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.CommitDiffSourceCodeType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CommitDiffSourceCodeType(")
        append("destinationCommit=$destinationCommit,")
        append("mergeBaseCommit=$mergeBaseCommit,")
        append("sourceCommit=$sourceCommit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationCommit?.hashCode() ?: 0
        result = 31 * result + (mergeBaseCommit?.hashCode() ?: 0)
        result = 31 * result + (sourceCommit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CommitDiffSourceCodeType

        if (destinationCommit != other.destinationCommit) return false
        if (mergeBaseCommit != other.mergeBaseCommit) return false
        if (sourceCommit != other.sourceCommit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.CommitDiffSourceCodeType = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The SHA of the destination commit used to generate a commit diff. This field is required for a pull request code review.
         */
        public var destinationCommit: kotlin.String? = null
        /**
         * The SHA of the merge base of a commit.
         */
        public var mergeBaseCommit: kotlin.String? = null
        /**
         * The SHA of the source commit used to generate a commit diff. This field is required for a pull request code review.
         */
        public var sourceCommit: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.CommitDiffSourceCodeType) : this() {
            this.destinationCommit = x.destinationCommit
            this.mergeBaseCommit = x.mergeBaseCommit
            this.sourceCommit = x.sourceCommit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.CommitDiffSourceCodeType = CommitDiffSourceCodeType(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
