// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codegurureviewer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the summary of the code review.
 */
public class CodeReviewSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the [CodeReview](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html) object.
     */
    public val codeReviewArn: kotlin.String? = builder.codeReviewArn
    /**
     * The time, in milliseconds since the epoch, when the code review was created.
     */
    public val createdTimeStamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTimeStamp
    /**
     * The time, in milliseconds since the epoch, when the code review was last updated.
     */
    public val lastUpdatedTimeStamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTimeStamp
    /**
     * The statistics from the code review.
     */
    public val metricsSummary: aws.sdk.kotlin.services.codegurureviewer.model.MetricsSummary? = builder.metricsSummary
    /**
     * The name of the code review.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository. For an S3 repository, it can be the username or Amazon Web Services account ID.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * The provider type of the repository association.
     */
    public val providerType: aws.sdk.kotlin.services.codegurureviewer.model.ProviderType? = builder.providerType
    /**
     * The pull request ID for the code review.
     */
    public val pullRequestId: kotlin.String? = builder.pullRequestId
    /**
     * The name of the repository.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName
    /**
     * Specifies the source code that is analyzed in a code review.
     */
    public val sourceCodeType: aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType? = builder.sourceCodeType
    /**
     * The state of the code review.
     *
     * The valid code review states are:
     * + `Completed`: The code review is complete.
     * + `Pending`: The code review started and has not completed or failed.
     * + `Failed`: The code review failed.
     * + `Deleting`: The code review is being deleted.
     */
    public val state: aws.sdk.kotlin.services.codegurureviewer.model.JobState? = builder.state
    /**
     * The type of the code review.
     */
    public val type: aws.sdk.kotlin.services.codegurureviewer.model.Type? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codegurureviewer.model.CodeReviewSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CodeReviewSummary(")
        append("codeReviewArn=$codeReviewArn,")
        append("createdTimeStamp=$createdTimeStamp,")
        append("lastUpdatedTimeStamp=$lastUpdatedTimeStamp,")
        append("metricsSummary=$metricsSummary,")
        append("name=$name,")
        append("owner=$owner,")
        append("providerType=$providerType,")
        append("pullRequestId=$pullRequestId,")
        append("repositoryName=$repositoryName,")
        append("sourceCodeType=$sourceCodeType,")
        append("state=$state,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = codeReviewArn?.hashCode() ?: 0
        result = 31 * result + (createdTimeStamp?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimeStamp?.hashCode() ?: 0)
        result = 31 * result + (metricsSummary?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (providerType?.hashCode() ?: 0)
        result = 31 * result + (pullRequestId?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        result = 31 * result + (sourceCodeType?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CodeReviewSummary

        if (codeReviewArn != other.codeReviewArn) return false
        if (createdTimeStamp != other.createdTimeStamp) return false
        if (lastUpdatedTimeStamp != other.lastUpdatedTimeStamp) return false
        if (metricsSummary != other.metricsSummary) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (providerType != other.providerType) return false
        if (pullRequestId != other.pullRequestId) return false
        if (repositoryName != other.repositoryName) return false
        if (sourceCodeType != other.sourceCodeType) return false
        if (state != other.state) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codegurureviewer.model.CodeReviewSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the [CodeReview](https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_CodeReview.html) object.
         */
        public var codeReviewArn: kotlin.String? = null
        /**
         * The time, in milliseconds since the epoch, when the code review was created.
         */
        public var createdTimeStamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time, in milliseconds since the epoch, when the code review was last updated.
         */
        public var lastUpdatedTimeStamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The statistics from the code review.
         */
        public var metricsSummary: aws.sdk.kotlin.services.codegurureviewer.model.MetricsSummary? = null
        /**
         * The name of the code review.
         */
        public var name: kotlin.String? = null
        /**
         * The owner of the repository. For an Amazon Web Services CodeCommit repository, this is the Amazon Web Services account ID of the account that owns the repository. For a GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the username for the account that owns the repository. For an S3 repository, it can be the username or Amazon Web Services account ID.
         */
        public var owner: kotlin.String? = null
        /**
         * The provider type of the repository association.
         */
        public var providerType: aws.sdk.kotlin.services.codegurureviewer.model.ProviderType? = null
        /**
         * The pull request ID for the code review.
         */
        public var pullRequestId: kotlin.String? = null
        /**
         * The name of the repository.
         */
        public var repositoryName: kotlin.String? = null
        /**
         * Specifies the source code that is analyzed in a code review.
         */
        public var sourceCodeType: aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType? = null
        /**
         * The state of the code review.
         *
         * The valid code review states are:
         * + `Completed`: The code review is complete.
         * + `Pending`: The code review started and has not completed or failed.
         * + `Failed`: The code review failed.
         * + `Deleting`: The code review is being deleted.
         */
        public var state: aws.sdk.kotlin.services.codegurureviewer.model.JobState? = null
        /**
         * The type of the code review.
         */
        public var type: aws.sdk.kotlin.services.codegurureviewer.model.Type? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codegurureviewer.model.CodeReviewSummary) : this() {
            this.codeReviewArn = x.codeReviewArn
            this.createdTimeStamp = x.createdTimeStamp
            this.lastUpdatedTimeStamp = x.lastUpdatedTimeStamp
            this.metricsSummary = x.metricsSummary
            this.name = x.name
            this.owner = x.owner
            this.providerType = x.providerType
            this.pullRequestId = x.pullRequestId
            this.repositoryName = x.repositoryName
            this.sourceCodeType = x.sourceCodeType
            this.state = x.state
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codegurureviewer.model.CodeReviewSummary = CodeReviewSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.MetricsSummary] inside the given [block]
         */
        public fun metricsSummary(block: aws.sdk.kotlin.services.codegurureviewer.model.MetricsSummary.Builder.() -> kotlin.Unit) {
            this.metricsSummary = aws.sdk.kotlin.services.codegurureviewer.model.MetricsSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType] inside the given [block]
         */
        public fun sourceCodeType(block: aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType.Builder.() -> kotlin.Unit) {
            this.sourceCodeType = aws.sdk.kotlin.services.codegurureviewer.model.SourceCodeType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
