// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codeguruprofiler.model.CodeGuruProfilerException
import aws.sdk.kotlin.services.codeguruprofiler.model.DescribeProfilingGroupResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer


internal class DescribeProfilingGroupOperationDeserializer: HttpDeserialize<DescribeProfilingGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeProfilingGroupResponse {
        if (!response.status.isSuccess()) {
            throwDescribeProfilingGroupError(context, response)
        }
        val builder = DescribeProfilingGroupResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeProfilingGroupOperationBody(builder, payload)
        }

        return builder.build()
    }
}

private suspend fun deserializeDescribeProfilingGroupOperationBody(builder: DescribeProfilingGroupResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    builder.profilingGroup = deserializeProfilingGroupDescriptionDocument(deserializer)
}

private suspend fun throwDescribeProfilingGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        "ValidationException" -> ValidationExceptionDeserializer()
        else -> throw CodeGuruProfilerException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
