// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * The structure representing the SubmitFeedbackRequest.
 */
class SubmitFeedbackRequest private constructor(builder: BuilderImpl) {
    /**
     * The universally unique identifier (UUID) of the
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AnomalyInstance.html">
     * AnomalyInstance
     * object
     * that is included in the analysis data.
     */
    val anomalyInstanceId: String? = builder.anomalyInstanceId
    /**
     * Optional feedback about this anomaly.
     */
    val comment: String? = builder.comment
    /**
     * The name of the profiling group that is associated with the analysis data.
     */
    val profilingGroupName: String? = builder.profilingGroupName
    /**
     * The feedback tpye. Thee are two valid values, Positive and Negative.
     */
    val type: FeedbackType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SubmitFeedbackRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SubmitFeedbackRequest(")
        append("anomalyInstanceId=$anomalyInstanceId,")
        append("comment=$comment,")
        append("profilingGroupName=$profilingGroupName,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = anomalyInstanceId?.hashCode() ?: 0
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (profilingGroupName?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SubmitFeedbackRequest

        if (anomalyInstanceId != other.anomalyInstanceId) return false
        if (comment != other.comment) return false
        if (profilingGroupName != other.profilingGroupName) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SubmitFeedbackRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SubmitFeedbackRequest
        /**
         * The universally unique identifier (UUID) of the
         * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AnomalyInstance.html">
         * AnomalyInstance
         * object
         * that is included in the analysis data.
         */
        fun anomalyInstanceId(anomalyInstanceId: String): FluentBuilder
        /**
         * Optional feedback about this anomaly.
         */
        fun comment(comment: String): FluentBuilder
        /**
         * The name of the profiling group that is associated with the analysis data.
         */
        fun profilingGroupName(profilingGroupName: String): FluentBuilder
        /**
         * The feedback tpye. Thee are two valid values, Positive and Negative.
         */
        fun type(type: FeedbackType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The universally unique identifier (UUID) of the
         * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AnomalyInstance.html">
         * AnomalyInstance
         * object
         * that is included in the analysis data.
         */
        var anomalyInstanceId: String?
        /**
         * Optional feedback about this anomaly.
         */
        var comment: String?
        /**
         * The name of the profiling group that is associated with the analysis data.
         */
        var profilingGroupName: String?
        /**
         * The feedback tpye. Thee are two valid values, Positive and Negative.
         */
        var type: FeedbackType?

        fun build(): SubmitFeedbackRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var anomalyInstanceId: String? = null
        override var comment: String? = null
        override var profilingGroupName: String? = null
        override var type: FeedbackType? = null

        constructor(x: SubmitFeedbackRequest) : this() {
            this.anomalyInstanceId = x.anomalyInstanceId
            this.comment = x.comment
            this.profilingGroupName = x.profilingGroupName
            this.type = x.type
        }

        override fun build(): SubmitFeedbackRequest = SubmitFeedbackRequest(this)
        override fun anomalyInstanceId(anomalyInstanceId: String): FluentBuilder = apply { this.anomalyInstanceId = anomalyInstanceId }
        override fun comment(comment: String): FluentBuilder = apply { this.comment = comment }
        override fun profilingGroupName(profilingGroupName: String): FluentBuilder = apply { this.profilingGroupName = profilingGroupName }
        override fun type(type: FeedbackType): FluentBuilder = apply { this.type = type }
    }
}
