// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A potential improvement that was found from analyzing the profiling data.
 */
class Recommendation private constructor(builder: BuilderImpl) {
    /**
     * How many different places in the profile graph triggered a match.
     */
    val allMatchesCount: Int? = builder.allMatchesCount
    /**
     * How much of the total sample count is potentially affected.
     */
    val allMatchesSum: Double? = builder.allMatchesSum
    /**
     * End time of the profile that was used by this analysis.
     * This is specified
     * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
     * millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The pattern that analysis recognized in the profile to make this recommendation.
     */
    val pattern: Pattern? = builder.pattern
    /**
     * The start time of the profile that was used by this analysis.
     * This is specified
     * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
     * millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    val startTime: Instant? = builder.startTime
    /**
     * List of the matches with most impact.
     */
    val topMatches: List<Match>? = builder.topMatches

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Recommendation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Recommendation(")
        append("allMatchesCount=$allMatchesCount,")
        append("allMatchesSum=$allMatchesSum,")
        append("endTime=$endTime,")
        append("pattern=$pattern,")
        append("startTime=$startTime,")
        append("topMatches=$topMatches)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allMatchesCount ?: 0
        result = 31 * result + (allMatchesSum?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (pattern?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (topMatches?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Recommendation

        if (allMatchesCount != other.allMatchesCount) return false
        if (allMatchesSum != other.allMatchesSum) return false
        if (endTime != other.endTime) return false
        if (pattern != other.pattern) return false
        if (startTime != other.startTime) return false
        if (topMatches != other.topMatches) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Recommendation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Recommendation
        /**
         * How many different places in the profile graph triggered a match.
         */
        fun allMatchesCount(allMatchesCount: Int): FluentBuilder
        /**
         * How much of the total sample count is potentially affected.
         */
        fun allMatchesSum(allMatchesSum: Double): FluentBuilder
        /**
         * End time of the profile that was used by this analysis.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The pattern that analysis recognized in the profile to make this recommendation.
         */
        fun pattern(pattern: Pattern): FluentBuilder
        /**
         * The start time of the profile that was used by this analysis.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * List of the matches with most impact.
         */
        fun topMatches(topMatches: List<Match>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * How many different places in the profile graph triggered a match.
         */
        var allMatchesCount: Int?
        /**
         * How much of the total sample count is potentially affected.
         */
        var allMatchesSum: Double?
        /**
         * End time of the profile that was used by this analysis.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        var endTime: Instant?
        /**
         * The pattern that analysis recognized in the profile to make this recommendation.
         */
        var pattern: Pattern?
        /**
         * The start time of the profile that was used by this analysis.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        var startTime: Instant?
        /**
         * List of the matches with most impact.
         */
        var topMatches: List<Match>?

        fun build(): Recommendation
        /**
         * construct an [aws.sdk.kotlin.services.codeguruprofiler.model.Pattern] inside the given [block]
         */
        fun pattern(block: Pattern.DslBuilder.() -> kotlin.Unit) {
            this.pattern = Pattern.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allMatchesCount: Int? = null
        override var allMatchesSum: Double? = null
        override var endTime: Instant? = null
        override var pattern: Pattern? = null
        override var startTime: Instant? = null
        override var topMatches: List<Match>? = null

        constructor(x: Recommendation) : this() {
            this.allMatchesCount = x.allMatchesCount
            this.allMatchesSum = x.allMatchesSum
            this.endTime = x.endTime
            this.pattern = x.pattern
            this.startTime = x.startTime
            this.topMatches = x.topMatches
        }

        override fun build(): Recommendation = Recommendation(this)
        override fun allMatchesCount(allMatchesCount: Int): FluentBuilder = apply { this.allMatchesCount = allMatchesCount }
        override fun allMatchesSum(allMatchesSum: Double): FluentBuilder = apply { this.allMatchesSum = allMatchesSum }
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun pattern(pattern: Pattern): FluentBuilder = apply { this.pattern = pattern }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun topMatches(topMatches: List<Match>): FluentBuilder = apply { this.topMatches = topMatches }
    }
}
