// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * The structure representing the putPermissionRequest.
 */
class PutPermissionRequest private constructor(builder: BuilderImpl) {
    /**
     * Specifies an action group that contains permissions to add to
     * a profiling group resource. One action group is supported, agentPermissions, which
     * grants permission to perform actions required by the profiling agent, ConfigureAgent
     * and PostAgentProfile permissions.
     */
    val actionGroup: ActionGroup? = builder.actionGroup
    /**
     * A list ARNs for the roles and users you want to grant access to the profiling group.
     * Wildcards are not are supported in the ARNs.
     */
    val principals: List<String>? = builder.principals
    /**
     * The name of the profiling group to grant access to.
     */
    val profilingGroupName: String? = builder.profilingGroupName
    /**
     * A universally unique identifier (UUID) for the revision of the policy you
     * are adding to the profiling group. Do not specify
     * this when you add permissions to a profiling group for the first time. If a policy already exists on the
     * profiling group, you must specify the revisionId.
     */
    val revisionId: String? = builder.revisionId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PutPermissionRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PutPermissionRequest(")
        append("actionGroup=$actionGroup,")
        append("principals=$principals,")
        append("profilingGroupName=$profilingGroupName,")
        append("revisionId=$revisionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionGroup?.hashCode() ?: 0
        result = 31 * result + (principals?.hashCode() ?: 0)
        result = 31 * result + (profilingGroupName?.hashCode() ?: 0)
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PutPermissionRequest

        if (actionGroup != other.actionGroup) return false
        if (principals != other.principals) return false
        if (profilingGroupName != other.profilingGroupName) return false
        if (revisionId != other.revisionId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PutPermissionRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PutPermissionRequest
        /**
         * Specifies an action group that contains permissions to add to
         * a profiling group resource. One action group is supported, agentPermissions, which
         * grants permission to perform actions required by the profiling agent, ConfigureAgent
         * and PostAgentProfile permissions.
         */
        fun actionGroup(actionGroup: ActionGroup): FluentBuilder
        /**
         * A list ARNs for the roles and users you want to grant access to the profiling group.
         * Wildcards are not are supported in the ARNs.
         */
        fun principals(principals: List<String>): FluentBuilder
        /**
         * The name of the profiling group to grant access to.
         */
        fun profilingGroupName(profilingGroupName: String): FluentBuilder
        /**
         * A universally unique identifier (UUID) for the revision of the policy you
         * are adding to the profiling group. Do not specify
         * this when you add permissions to a profiling group for the first time. If a policy already exists on the
         * profiling group, you must specify the revisionId.
         */
        fun revisionId(revisionId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies an action group that contains permissions to add to
         * a profiling group resource. One action group is supported, agentPermissions, which
         * grants permission to perform actions required by the profiling agent, ConfigureAgent
         * and PostAgentProfile permissions.
         */
        var actionGroup: ActionGroup?
        /**
         * A list ARNs for the roles and users you want to grant access to the profiling group.
         * Wildcards are not are supported in the ARNs.
         */
        var principals: List<String>?
        /**
         * The name of the profiling group to grant access to.
         */
        var profilingGroupName: String?
        /**
         * A universally unique identifier (UUID) for the revision of the policy you
         * are adding to the profiling group. Do not specify
         * this when you add permissions to a profiling group for the first time. If a policy already exists on the
         * profiling group, you must specify the revisionId.
         */
        var revisionId: String?

        fun build(): PutPermissionRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var actionGroup: ActionGroup? = null
        override var principals: List<String>? = null
        override var profilingGroupName: String? = null
        override var revisionId: String? = null

        constructor(x: PutPermissionRequest) : this() {
            this.actionGroup = x.actionGroup
            this.principals = x.principals
            this.profilingGroupName = x.profilingGroupName
            this.revisionId = x.revisionId
        }

        override fun build(): PutPermissionRequest = PutPermissionRequest(this)
        override fun actionGroup(actionGroup: ActionGroup): FluentBuilder = apply { this.actionGroup = actionGroup }
        override fun principals(principals: List<String>): FluentBuilder = apply { this.principals = principals }
        override fun profilingGroupName(profilingGroupName: String): FluentBuilder = apply { this.profilingGroupName = profilingGroupName }
        override fun revisionId(revisionId: String): FluentBuilder = apply { this.revisionId = revisionId }
    }
}
