// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Profiling status includes information about the last time a profile agent pinged back,
 * the last time a profile was received, and the aggregation period and start time for the
 * most recent aggregated profile.
 */
class ProfilingStatus private constructor(builder: BuilderImpl) {
    /**
     * The date and time when the profiling agent most recently pinged back. Specify using
     * the ISO 8601 format. For example,
     * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    val latestAgentOrchestratedAt: Instant? = builder.latestAgentOrchestratedAt
    /**
     * The date and time when the most recent profile was received. Specify using
     * the ISO 8601 format. For example,
     * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    val latestAgentProfileReportedAt: Instant? = builder.latestAgentProfileReportedAt
    /**
     * An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html">
     * AggregatedProfileTime
     * object that contains the aggregation period and start time for an aggregated profile.
     */
    val latestAggregatedProfile: AggregatedProfileTime? = builder.latestAggregatedProfile

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ProfilingStatus = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ProfilingStatus(")
        append("latestAgentOrchestratedAt=$latestAgentOrchestratedAt,")
        append("latestAgentProfileReportedAt=$latestAgentProfileReportedAt,")
        append("latestAggregatedProfile=$latestAggregatedProfile)")
    }

    override fun hashCode(): kotlin.Int {
        var result = latestAgentOrchestratedAt?.hashCode() ?: 0
        result = 31 * result + (latestAgentProfileReportedAt?.hashCode() ?: 0)
        result = 31 * result + (latestAggregatedProfile?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ProfilingStatus

        if (latestAgentOrchestratedAt != other.latestAgentOrchestratedAt) return false
        if (latestAgentProfileReportedAt != other.latestAgentProfileReportedAt) return false
        if (latestAggregatedProfile != other.latestAggregatedProfile) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ProfilingStatus = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ProfilingStatus
        /**
         * The date and time when the profiling agent most recently pinged back. Specify using
         * the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        fun latestAgentOrchestratedAt(latestAgentOrchestratedAt: Instant): FluentBuilder
        /**
         * The date and time when the most recent profile was received. Specify using
         * the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        fun latestAgentProfileReportedAt(latestAgentProfileReportedAt: Instant): FluentBuilder
        /**
         * An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html">
         * AggregatedProfileTime
         * object that contains the aggregation period and start time for an aggregated profile.
         */
        fun latestAggregatedProfile(latestAggregatedProfile: AggregatedProfileTime): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date and time when the profiling agent most recently pinged back. Specify using
         * the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        var latestAgentOrchestratedAt: Instant?
        /**
         * The date and time when the most recent profile was received. Specify using
         * the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        var latestAgentProfileReportedAt: Instant?
        /**
         * An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html">
         * AggregatedProfileTime
         * object that contains the aggregation period and start time for an aggregated profile.
         */
        var latestAggregatedProfile: AggregatedProfileTime?

        fun build(): ProfilingStatus
        /**
         * construct an [aws.sdk.kotlin.services.codeguruprofiler.model.AggregatedProfileTime] inside the given [block]
         */
        fun latestAggregatedProfile(block: AggregatedProfileTime.DslBuilder.() -> kotlin.Unit) {
            this.latestAggregatedProfile = AggregatedProfileTime.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var latestAgentOrchestratedAt: Instant? = null
        override var latestAgentProfileReportedAt: Instant? = null
        override var latestAggregatedProfile: AggregatedProfileTime? = null

        constructor(x: ProfilingStatus) : this() {
            this.latestAgentOrchestratedAt = x.latestAgentOrchestratedAt
            this.latestAgentProfileReportedAt = x.latestAgentProfileReportedAt
            this.latestAggregatedProfile = x.latestAggregatedProfile
        }

        override fun build(): ProfilingStatus = ProfilingStatus(this)
        override fun latestAgentOrchestratedAt(latestAgentOrchestratedAt: Instant): FluentBuilder = apply { this.latestAgentOrchestratedAt = latestAgentOrchestratedAt }
        override fun latestAgentProfileReportedAt(latestAgentProfileReportedAt: Instant): FluentBuilder = apply { this.latestAgentProfileReportedAt = latestAgentProfileReportedAt }
        override fun latestAggregatedProfile(latestAggregatedProfile: AggregatedProfileTime): FluentBuilder = apply { this.latestAggregatedProfile = latestAggregatedProfile }
    }
}
