// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a profiling group.
 */
class ProfilingGroupDescription private constructor(builder: BuilderImpl) {
    /**
     * An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentOrchestrationConfig.html">
     * AgentOrchestrationConfig
     * object that indicates if the profiling group is enabled for profiled or not.
     */
    val agentOrchestrationConfig: AgentOrchestrationConfig? = builder.agentOrchestrationConfig
    /**
     * The Amazon Resource Name (ARN) identifying the profiling group resource.
     */
    val arn: String? = builder.arn
    /**
     * The compute platform of the profiling group. If it is set to AWSLambda, then
     * the profiled application runs on AWS Lambda. If it is set to Default, then the
     * profiled application runs on a compute platform that is not AWS Lambda, such an Amazon EC2 instance,
     * an on-premises server, or a different platform. The default is Default.
     */
    val computePlatform: ComputePlatform? = builder.computePlatform
    /**
     * The time when the profiling group was created. Specify using
     * the ISO 8601 format. For example,
     * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The name of the profiling group.
     */
    val name: String? = builder.name
    /**
     * A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingStatus.html">
     * ProfilingStatus
     * object
     * that includes information about the last time a profile agent pinged back,
     * the last time a profile was received, and the aggregation period and start time for the
     * most recent aggregated profile.
     */
    val profilingStatus: ProfilingStatus? = builder.profilingStatus
    /**
     * A list of the tags that belong to this profiling group.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The date and time when the profiling group was last updated. Specify using
     * the ISO 8601 format. For example,
     * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    val updatedAt: Instant? = builder.updatedAt

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ProfilingGroupDescription = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ProfilingGroupDescription(")
        append("agentOrchestrationConfig=$agentOrchestrationConfig,")
        append("arn=$arn,")
        append("computePlatform=$computePlatform,")
        append("createdAt=$createdAt,")
        append("name=$name,")
        append("profilingStatus=$profilingStatus,")
        append("tags=$tags,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentOrchestrationConfig?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (computePlatform?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (profilingStatus?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ProfilingGroupDescription

        if (agentOrchestrationConfig != other.agentOrchestrationConfig) return false
        if (arn != other.arn) return false
        if (computePlatform != other.computePlatform) return false
        if (createdAt != other.createdAt) return false
        if (name != other.name) return false
        if (profilingStatus != other.profilingStatus) return false
        if (tags != other.tags) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ProfilingGroupDescription = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ProfilingGroupDescription
        /**
         * An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentOrchestrationConfig.html">
         * AgentOrchestrationConfig
         * object that indicates if the profiling group is enabled for profiled or not.
         */
        fun agentOrchestrationConfig(agentOrchestrationConfig: AgentOrchestrationConfig): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) identifying the profiling group resource.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The compute platform of the profiling group. If it is set to AWSLambda, then
         * the profiled application runs on AWS Lambda. If it is set to Default, then the
         * profiled application runs on a compute platform that is not AWS Lambda, such an Amazon EC2 instance,
         * an on-premises server, or a different platform. The default is Default.
         */
        fun computePlatform(computePlatform: ComputePlatform): FluentBuilder
        /**
         * The time when the profiling group was created. Specify using
         * the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The name of the profiling group.
         */
        fun name(name: String): FluentBuilder
        /**
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingStatus.html">
         * ProfilingStatus
         * object
         * that includes information about the last time a profile agent pinged back,
         * the last time a profile was received, and the aggregation period and start time for the
         * most recent aggregated profile.
         */
        fun profilingStatus(profilingStatus: ProfilingStatus): FluentBuilder
        /**
         * A list of the tags that belong to this profiling group.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The date and time when the profiling group was last updated. Specify using
         * the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        fun updatedAt(updatedAt: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentOrchestrationConfig.html">
         * AgentOrchestrationConfig
         * object that indicates if the profiling group is enabled for profiled or not.
         */
        var agentOrchestrationConfig: AgentOrchestrationConfig?
        /**
         * The Amazon Resource Name (ARN) identifying the profiling group resource.
         */
        var arn: String?
        /**
         * The compute platform of the profiling group. If it is set to AWSLambda, then
         * the profiled application runs on AWS Lambda. If it is set to Default, then the
         * profiled application runs on a compute platform that is not AWS Lambda, such an Amazon EC2 instance,
         * an on-premises server, or a different platform. The default is Default.
         */
        var computePlatform: ComputePlatform?
        /**
         * The time when the profiling group was created. Specify using
         * the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        var createdAt: Instant?
        /**
         * The name of the profiling group.
         */
        var name: String?
        /**
         * A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingStatus.html">
         * ProfilingStatus
         * object
         * that includes information about the last time a profile agent pinged back,
         * the last time a profile was received, and the aggregation period and start time for the
         * most recent aggregated profile.
         */
        var profilingStatus: ProfilingStatus?
        /**
         * A list of the tags that belong to this profiling group.
         */
        var tags: Map<String, String>?
        /**
         * The date and time when the profiling group was last updated. Specify using
         * the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        var updatedAt: Instant?

        fun build(): ProfilingGroupDescription
        /**
         * construct an [aws.sdk.kotlin.services.codeguruprofiler.model.AgentOrchestrationConfig] inside the given [block]
         */
        fun agentOrchestrationConfig(block: AgentOrchestrationConfig.DslBuilder.() -> kotlin.Unit) {
            this.agentOrchestrationConfig = AgentOrchestrationConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.codeguruprofiler.model.ProfilingStatus] inside the given [block]
         */
        fun profilingStatus(block: ProfilingStatus.DslBuilder.() -> kotlin.Unit) {
            this.profilingStatus = ProfilingStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var agentOrchestrationConfig: AgentOrchestrationConfig? = null
        override var arn: String? = null
        override var computePlatform: ComputePlatform? = null
        override var createdAt: Instant? = null
        override var name: String? = null
        override var profilingStatus: ProfilingStatus? = null
        override var tags: Map<String, String>? = null
        override var updatedAt: Instant? = null

        constructor(x: ProfilingGroupDescription) : this() {
            this.agentOrchestrationConfig = x.agentOrchestrationConfig
            this.arn = x.arn
            this.computePlatform = x.computePlatform
            this.createdAt = x.createdAt
            this.name = x.name
            this.profilingStatus = x.profilingStatus
            this.tags = x.tags
            this.updatedAt = x.updatedAt
        }

        override fun build(): ProfilingGroupDescription = ProfilingGroupDescription(this)
        override fun agentOrchestrationConfig(agentOrchestrationConfig: AgentOrchestrationConfig): FluentBuilder = apply { this.agentOrchestrationConfig = agentOrchestrationConfig }
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun computePlatform(computePlatform: ComputePlatform): FluentBuilder = apply { this.computePlatform = computePlatform }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun profilingStatus(profilingStatus: ProfilingStatus): FluentBuilder = apply { this.profilingStatus = profilingStatus }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun updatedAt(updatedAt: Instant): FluentBuilder = apply { this.updatedAt = updatedAt }
    }
}
