// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * The structure representing the postAgentProfileRequest.
 */
class PostAgentProfileRequest private constructor(builder: BuilderImpl) {
    /**
     * The submitted profiling data.
     */
    val agentProfile: ByteArray? = builder.agentProfile
    /**
     * The format of the submitted profiling data. The format maps to the
     * Accept and Content-Type headers of the
     * HTTP request. You can specify one of the following:
     * or the default .
     * application/json — standard JSON format
     * application/x-amzn-ion — the Amazon Ion data format. For more information,
     * see <a href="http://amzn.github.io/ion-docs/">Amazon Ion.
     */
    val contentType: String? = builder.contentType
    /**
     * Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the
     * accidental submission of duplicate profiling data if there are failures and retries.
     */
    val profileToken: String? = builder.profileToken
    /**
     * The name of the profiling group with the aggregated profile that receives the
     * submitted profiling data.
     */
    val profilingGroupName: String? = builder.profilingGroupName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): PostAgentProfileRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("PostAgentProfileRequest(")
        append("agentProfile=$agentProfile,")
        append("contentType=$contentType,")
        append("profileToken=$profileToken,")
        append("profilingGroupName=$profilingGroupName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentProfile?.contentHashCode() ?: 0
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (profileToken?.hashCode() ?: 0)
        result = 31 * result + (profilingGroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as PostAgentProfileRequest

        if (agentProfile != null) {
            if (other.agentProfile == null) return false
            if (!agentProfile.contentEquals(other.agentProfile)) return false
        } else if (other.agentProfile != null) return false
        if (contentType != other.contentType) return false
        if (profileToken != other.profileToken) return false
        if (profilingGroupName != other.profilingGroupName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): PostAgentProfileRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): PostAgentProfileRequest
        /**
         * The submitted profiling data.
         */
        fun agentProfile(agentProfile: ByteArray): FluentBuilder
        /**
         * The format of the submitted profiling data. The format maps to the
         * Accept and Content-Type headers of the
         * HTTP request. You can specify one of the following:
         * or the default .
         * application/json — standard JSON format
         * application/x-amzn-ion — the Amazon Ion data format. For more information,
         * see <a href="http://amzn.github.io/ion-docs/">Amazon Ion.
         */
        fun contentType(contentType: String): FluentBuilder
        /**
         * Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the
         * accidental submission of duplicate profiling data if there are failures and retries.
         */
        fun profileToken(profileToken: String): FluentBuilder
        /**
         * The name of the profiling group with the aggregated profile that receives the
         * submitted profiling data.
         */
        fun profilingGroupName(profilingGroupName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The submitted profiling data.
         */
        var agentProfile: ByteArray?
        /**
         * The format of the submitted profiling data. The format maps to the
         * Accept and Content-Type headers of the
         * HTTP request. You can specify one of the following:
         * or the default .
         * application/json — standard JSON format
         * application/x-amzn-ion — the Amazon Ion data format. For more information,
         * see <a href="http://amzn.github.io/ion-docs/">Amazon Ion.
         */
        var contentType: String?
        /**
         * Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the
         * accidental submission of duplicate profiling data if there are failures and retries.
         */
        var profileToken: String?
        /**
         * The name of the profiling group with the aggregated profile that receives the
         * submitted profiling data.
         */
        var profilingGroupName: String?

        fun build(): PostAgentProfileRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var agentProfile: ByteArray? = null
        override var contentType: String? = null
        override var profileToken: String? = null
        override var profilingGroupName: String? = null

        constructor(x: PostAgentProfileRequest) : this() {
            this.agentProfile = x.agentProfile
            this.contentType = x.contentType
            this.profileToken = x.profileToken
            this.profilingGroupName = x.profilingGroupName
        }

        override fun build(): PostAgentProfileRequest = PostAgentProfileRequest(this)
        override fun agentProfile(agentProfile: ByteArray): FluentBuilder = apply { this.agentProfile = agentProfile }
        override fun contentType(contentType: String): FluentBuilder = apply { this.contentType = contentType }
        override fun profileToken(profileToken: String): FluentBuilder = apply { this.profileToken = profileToken }
        override fun profilingGroupName(profilingGroupName: String): FluentBuilder = apply { this.profilingGroupName = profilingGroupName }
    }
}
