// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * A set of rules used to make a recommendation during an analysis.
 */
class Pattern private constructor(builder: BuilderImpl) {
    /**
     * A list of the different counters used to determine if there is a match.
     */
    val countersToAggregate: List<String>? = builder.countersToAggregate
    /**
     * The description of the recommendation. This explains a potential
     * inefficiency in a profiled application.
     */
    val description: String? = builder.description
    /**
     * The universally unique identifier (UUID) of this pattern.
     */
    val id: String? = builder.id
    /**
     * The name for this pattern.
     */
    val name: String? = builder.name
    /**
     * A string that contains the steps recommended to address the potential inefficiency.
     */
    val resolutionSteps: String? = builder.resolutionSteps
    /**
     * A list of frame names that were searched during the analysis that generated
     * a recommendation.
     */
    val targetFrames: List<List<String>>? = builder.targetFrames
    /**
     * The percentage of time an application spends in one method that triggers
     * a recommendation. The percentage of time is the same as the percentage of
     * the total gathered sample counts during analysis.
     */
    val thresholdPercent: Double = builder.thresholdPercent

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Pattern = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Pattern(")
        append("countersToAggregate=$countersToAggregate,")
        append("description=$description,")
        append("id=$id,")
        append("name=$name,")
        append("resolutionSteps=$resolutionSteps,")
        append("targetFrames=$targetFrames,")
        append("thresholdPercent=$thresholdPercent)")
    }

    override fun hashCode(): kotlin.Int {
        var result = countersToAggregate?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resolutionSteps?.hashCode() ?: 0)
        result = 31 * result + (targetFrames?.hashCode() ?: 0)
        result = 31 * result + (thresholdPercent.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Pattern

        if (countersToAggregate != other.countersToAggregate) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (resolutionSteps != other.resolutionSteps) return false
        if (targetFrames != other.targetFrames) return false
        if (thresholdPercent != other.thresholdPercent) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Pattern = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Pattern
        /**
         * A list of the different counters used to determine if there is a match.
         */
        fun countersToAggregate(countersToAggregate: List<String>): FluentBuilder
        /**
         * The description of the recommendation. This explains a potential
         * inefficiency in a profiled application.
         */
        fun description(description: String): FluentBuilder
        /**
         * The universally unique identifier (UUID) of this pattern.
         */
        fun id(id: String): FluentBuilder
        /**
         * The name for this pattern.
         */
        fun name(name: String): FluentBuilder
        /**
         * A string that contains the steps recommended to address the potential inefficiency.
         */
        fun resolutionSteps(resolutionSteps: String): FluentBuilder
        /**
         * A list of frame names that were searched during the analysis that generated
         * a recommendation.
         */
        fun targetFrames(targetFrames: List<List<String>>): FluentBuilder
        /**
         * The percentage of time an application spends in one method that triggers
         * a recommendation. The percentage of time is the same as the percentage of
         * the total gathered sample counts during analysis.
         */
        fun thresholdPercent(thresholdPercent: Double): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list of the different counters used to determine if there is a match.
         */
        var countersToAggregate: List<String>?
        /**
         * The description of the recommendation. This explains a potential
         * inefficiency in a profiled application.
         */
        var description: String?
        /**
         * The universally unique identifier (UUID) of this pattern.
         */
        var id: String?
        /**
         * The name for this pattern.
         */
        var name: String?
        /**
         * A string that contains the steps recommended to address the potential inefficiency.
         */
        var resolutionSteps: String?
        /**
         * A list of frame names that were searched during the analysis that generated
         * a recommendation.
         */
        var targetFrames: List<List<String>>?
        /**
         * The percentage of time an application spends in one method that triggers
         * a recommendation. The percentage of time is the same as the percentage of
         * the total gathered sample counts during analysis.
         */
        var thresholdPercent: Double

        fun build(): Pattern
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var countersToAggregate: List<String>? = null
        override var description: String? = null
        override var id: String? = null
        override var name: String? = null
        override var resolutionSteps: String? = null
        override var targetFrames: List<List<String>>? = null
        override var thresholdPercent: Double = 0.0

        constructor(x: Pattern) : this() {
            this.countersToAggregate = x.countersToAggregate
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.resolutionSteps = x.resolutionSteps
            this.targetFrames = x.targetFrames
            this.thresholdPercent = x.thresholdPercent
        }

        override fun build(): Pattern = Pattern(this)
        override fun countersToAggregate(countersToAggregate: List<String>): FluentBuilder = apply { this.countersToAggregate = countersToAggregate }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun resolutionSteps(resolutionSteps: String): FluentBuilder = apply { this.resolutionSteps = resolutionSteps }
        override fun targetFrames(targetFrames: List<List<String>>): FluentBuilder = apply { this.targetFrames = targetFrames }
        override fun thresholdPercent(thresholdPercent: Double): FluentBuilder = apply { this.thresholdPercent = thresholdPercent }
    }
}
