// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * Details about the metric that the analysis used when it detected the anomaly.
 * The metric what is analyzed to create recommendations. It includes the name of the
 * frame that was analyzed and the type and thread states used to derive the metric
 * value for that frame.
 */
class Metric private constructor(builder: BuilderImpl) {
    /**
     * The name of the method that appears as a frame in any stack in a profile.
     */
    val frameName: String? = builder.frameName
    /**
     * The list of application runtime thread states that is used to calculate the
     * metric value for the frame.
     */
    val threadStates: List<String>? = builder.threadStates
    /**
     * A type that specifies how a metric for a frame is analyzed.
     * The supported value AggregatedRelativeTotalTime is an
     * aggregation of the metric value for one frame that is calculated across the
     * occurences of all frames in a profile.
     */
    val type: MetricType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Metric = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Metric(")
        append("frameName=$frameName,")
        append("threadStates=$threadStates,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = frameName?.hashCode() ?: 0
        result = 31 * result + (threadStates?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Metric

        if (frameName != other.frameName) return false
        if (threadStates != other.threadStates) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Metric = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Metric
        /**
         * The name of the method that appears as a frame in any stack in a profile.
         */
        fun frameName(frameName: String): FluentBuilder
        /**
         * The list of application runtime thread states that is used to calculate the
         * metric value for the frame.
         */
        fun threadStates(threadStates: List<String>): FluentBuilder
        /**
         * A type that specifies how a metric for a frame is analyzed.
         * The supported value AggregatedRelativeTotalTime is an
         * aggregation of the metric value for one frame that is calculated across the
         * occurences of all frames in a profile.
         */
        fun type(type: MetricType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the method that appears as a frame in any stack in a profile.
         */
        var frameName: String?
        /**
         * The list of application runtime thread states that is used to calculate the
         * metric value for the frame.
         */
        var threadStates: List<String>?
        /**
         * A type that specifies how a metric for a frame is analyzed.
         * The supported value AggregatedRelativeTotalTime is an
         * aggregation of the metric value for one frame that is calculated across the
         * occurences of all frames in a profile.
         */
        var type: MetricType?

        fun build(): Metric
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var frameName: String? = null
        override var threadStates: List<String>? = null
        override var type: MetricType? = null

        constructor(x: Metric) : this() {
            this.frameName = x.frameName
            this.threadStates = x.threadStates
            this.type = x.type
        }

        override fun build(): Metric = Metric(this)
        override fun frameName(frameName: String): FluentBuilder = apply { this.frameName = frameName }
        override fun threadStates(threadStates: List<String>): FluentBuilder = apply { this.threadStates = threadStates }
        override fun type(type: MetricType): FluentBuilder = apply { this.type = type }
    }
}
