// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * The part of a profile that contains a recommendation found during analysis.
 */
class Match private constructor(builder: BuilderImpl) {
    /**
     * The location in the profiling graph that contains a recommendation found during analysis.
     */
    val frameAddress: String? = builder.frameAddress
    /**
     * The target frame that triggered a match.
     */
    val targetFramesIndex: Int? = builder.targetFramesIndex
    /**
     * The value in the profile data that exceeded the recommendation threshold.
     */
    val thresholdBreachValue: Double? = builder.thresholdBreachValue

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Match = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Match(")
        append("frameAddress=$frameAddress,")
        append("targetFramesIndex=$targetFramesIndex,")
        append("thresholdBreachValue=$thresholdBreachValue)")
    }

    override fun hashCode(): kotlin.Int {
        var result = frameAddress?.hashCode() ?: 0
        result = 31 * result + (targetFramesIndex ?: 0)
        result = 31 * result + (thresholdBreachValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Match

        if (frameAddress != other.frameAddress) return false
        if (targetFramesIndex != other.targetFramesIndex) return false
        if (thresholdBreachValue != other.thresholdBreachValue) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Match = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Match
        /**
         * The location in the profiling graph that contains a recommendation found during analysis.
         */
        fun frameAddress(frameAddress: String): FluentBuilder
        /**
         * The target frame that triggered a match.
         */
        fun targetFramesIndex(targetFramesIndex: Int): FluentBuilder
        /**
         * The value in the profile data that exceeded the recommendation threshold.
         */
        fun thresholdBreachValue(thresholdBreachValue: Double): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The location in the profiling graph that contains a recommendation found during analysis.
         */
        var frameAddress: String?
        /**
         * The target frame that triggered a match.
         */
        var targetFramesIndex: Int?
        /**
         * The value in the profile data that exceeded the recommendation threshold.
         */
        var thresholdBreachValue: Double?

        fun build(): Match
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var frameAddress: String? = null
        override var targetFramesIndex: Int? = null
        override var thresholdBreachValue: Double? = null

        constructor(x: Match) : this() {
            this.frameAddress = x.frameAddress
            this.targetFramesIndex = x.targetFramesIndex
            this.thresholdBreachValue = x.thresholdBreachValue
        }

        override fun build(): Match = Match(this)
        override fun frameAddress(frameAddress: String): FluentBuilder = apply { this.frameAddress = frameAddress }
        override fun targetFramesIndex(targetFramesIndex: Int): FluentBuilder = apply { this.targetFramesIndex = targetFramesIndex }
        override fun thresholdBreachValue(thresholdBreachValue: Double): FluentBuilder = apply { this.thresholdBreachValue = thresholdBreachValue }
    }
}
