// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * The structure representing the listProfilingGroupsRequest.
 */
class ListProfilingGroupsRequest private constructor(builder: BuilderImpl) {
    /**
     * A Boolean value indicating whether to include a description. If true,
     * then a list of
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     * ProfilingGroupDescription
     * objects
     * that contain detailed information about profiling groups is returned. If false, then
     * a list of profiling group names is returned.
     */
    val includeDescription: Boolean? = builder.includeDescription
    /**
     * The maximum number of profiling groups results returned by ListProfilingGroups
     * in paginated output. When this parameter is used, ListProfilingGroups only returns
     * maxResults results in a single page along with a nextToken response
     * element. The remaining results of the initial request
     * can be seen by sending another ListProfilingGroups request with the returned
     * nextToken value.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The nextToken value returned from a previous paginated
     * ListProfilingGroups request where maxResults was used and the results
     * exceeded the value of that parameter. Pagination continues from the end of the previous results
     * that returned the nextToken value.
     * This token should be treated as an opaque identifier that is only used to retrieve
     * the next items in a list and not for other programmatic purposes.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListProfilingGroupsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListProfilingGroupsRequest(")
        append("includeDescription=$includeDescription,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = includeDescription?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListProfilingGroupsRequest

        if (includeDescription != other.includeDescription) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListProfilingGroupsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListProfilingGroupsRequest
        /**
         * A Boolean value indicating whether to include a description. If true,
         * then a list of
         * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         * ProfilingGroupDescription
         * objects
         * that contain detailed information about profiling groups is returned. If false, then
         * a list of profiling group names is returned.
         */
        fun includeDescription(includeDescription: Boolean): FluentBuilder
        /**
         * The maximum number of profiling groups results returned by ListProfilingGroups
         * in paginated output. When this parameter is used, ListProfilingGroups only returns
         * maxResults results in a single page along with a nextToken response
         * element. The remaining results of the initial request
         * can be seen by sending another ListProfilingGroups request with the returned
         * nextToken value.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The nextToken value returned from a previous paginated
         * ListProfilingGroups request where maxResults was used and the results
         * exceeded the value of that parameter. Pagination continues from the end of the previous results
         * that returned the nextToken value.
         * This token should be treated as an opaque identifier that is only used to retrieve
         * the next items in a list and not for other programmatic purposes.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A Boolean value indicating whether to include a description. If true,
         * then a list of
         * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
         * ProfilingGroupDescription
         * objects
         * that contain detailed information about profiling groups is returned. If false, then
         * a list of profiling group names is returned.
         */
        var includeDescription: Boolean?
        /**
         * The maximum number of profiling groups results returned by ListProfilingGroups
         * in paginated output. When this parameter is used, ListProfilingGroups only returns
         * maxResults results in a single page along with a nextToken response
         * element. The remaining results of the initial request
         * can be seen by sending another ListProfilingGroups request with the returned
         * nextToken value.
         */
        var maxResults: Int?
        /**
         * The nextToken value returned from a previous paginated
         * ListProfilingGroups request where maxResults was used and the results
         * exceeded the value of that parameter. Pagination continues from the end of the previous results
         * that returned the nextToken value.
         * This token should be treated as an opaque identifier that is only used to retrieve
         * the next items in a list and not for other programmatic purposes.
         */
        var nextToken: String?

        fun build(): ListProfilingGroupsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var includeDescription: Boolean? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null

        constructor(x: ListProfilingGroupsRequest) : this() {
            this.includeDescription = x.includeDescription
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): ListProfilingGroupsRequest = ListProfilingGroupsRequest(this)
        override fun includeDescription(includeDescription: Boolean): FluentBuilder = apply { this.includeDescription = includeDescription }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
