// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The structure representing the listProfileTimesRequest.
 */
class ListProfileTimesRequest private constructor(builder: BuilderImpl) {
    /**
     * The end time of the time range from which to list the profiles.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The maximum number of profile time results returned by ListProfileTimes
     * in paginated output. When this parameter is used, ListProfileTimes only returns
     * maxResults results in a single page with a nextToken response
     * element. The remaining results of the initial request
     * can be seen by sending another ListProfileTimes request with the returned
     * nextToken value.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The nextToken value returned from a previous paginated
     * ListProfileTimes request where maxResults was used and the results
     * exceeded the value of that parameter. Pagination continues from the end of the previous results
     * that returned the nextToken value.
     * This token should be treated as an opaque identifier that is only used to retrieve
     * the next items in a list and not for other programmatic purposes.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The order (ascending or descending by start time of the profile) to
     * use when listing profiles. Defaults to TIMESTAMP_DESCENDING.
     */
    val orderBy: OrderBy? = builder.orderBy
    /**
     * The aggregation period. This specifies the period during which an aggregation profile
     * collects posted agent profiles for a profiling group. There are 3 valid values.
     * P1D — 1 day
     * PT1H — 1 hour
     * PT5M — 5 minutes
     */
    val period: AggregationPeriod? = builder.period
    /**
     * The name of the profiling group.
     */
    val profilingGroupName: String? = builder.profilingGroupName
    /**
     * The start time of the time range from which to list the profiles.
     */
    val startTime: Instant? = builder.startTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListProfileTimesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListProfileTimesRequest(")
        append("endTime=$endTime,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("orderBy=$orderBy,")
        append("period=$period,")
        append("profilingGroupName=$profilingGroupName,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (orderBy?.hashCode() ?: 0)
        result = 31 * result + (period?.hashCode() ?: 0)
        result = 31 * result + (profilingGroupName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListProfileTimesRequest

        if (endTime != other.endTime) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (orderBy != other.orderBy) return false
        if (period != other.period) return false
        if (profilingGroupName != other.profilingGroupName) return false
        if (startTime != other.startTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListProfileTimesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListProfileTimesRequest
        /**
         * The end time of the time range from which to list the profiles.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The maximum number of profile time results returned by ListProfileTimes
         * in paginated output. When this parameter is used, ListProfileTimes only returns
         * maxResults results in a single page with a nextToken response
         * element. The remaining results of the initial request
         * can be seen by sending another ListProfileTimes request with the returned
         * nextToken value.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The nextToken value returned from a previous paginated
         * ListProfileTimes request where maxResults was used and the results
         * exceeded the value of that parameter. Pagination continues from the end of the previous results
         * that returned the nextToken value.
         * This token should be treated as an opaque identifier that is only used to retrieve
         * the next items in a list and not for other programmatic purposes.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The order (ascending or descending by start time of the profile) to
         * use when listing profiles. Defaults to TIMESTAMP_DESCENDING.
         */
        fun orderBy(orderBy: OrderBy): FluentBuilder
        /**
         * The aggregation period. This specifies the period during which an aggregation profile
         * collects posted agent profiles for a profiling group. There are 3 valid values.
         * P1D — 1 day
         * PT1H — 1 hour
         * PT5M — 5 minutes
         */
        fun period(period: AggregationPeriod): FluentBuilder
        /**
         * The name of the profiling group.
         */
        fun profilingGroupName(profilingGroupName: String): FluentBuilder
        /**
         * The start time of the time range from which to list the profiles.
         */
        fun startTime(startTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The end time of the time range from which to list the profiles.
         */
        var endTime: Instant?
        /**
         * The maximum number of profile time results returned by ListProfileTimes
         * in paginated output. When this parameter is used, ListProfileTimes only returns
         * maxResults results in a single page with a nextToken response
         * element. The remaining results of the initial request
         * can be seen by sending another ListProfileTimes request with the returned
         * nextToken value.
         */
        var maxResults: Int?
        /**
         * The nextToken value returned from a previous paginated
         * ListProfileTimes request where maxResults was used and the results
         * exceeded the value of that parameter. Pagination continues from the end of the previous results
         * that returned the nextToken value.
         * This token should be treated as an opaque identifier that is only used to retrieve
         * the next items in a list and not for other programmatic purposes.
         */
        var nextToken: String?
        /**
         * The order (ascending or descending by start time of the profile) to
         * use when listing profiles. Defaults to TIMESTAMP_DESCENDING.
         */
        var orderBy: OrderBy?
        /**
         * The aggregation period. This specifies the period during which an aggregation profile
         * collects posted agent profiles for a profiling group. There are 3 valid values.
         * P1D — 1 day
         * PT1H — 1 hour
         * PT5M — 5 minutes
         */
        var period: AggregationPeriod?
        /**
         * The name of the profiling group.
         */
        var profilingGroupName: String?
        /**
         * The start time of the time range from which to list the profiles.
         */
        var startTime: Instant?

        fun build(): ListProfileTimesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var endTime: Instant? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var orderBy: OrderBy? = null
        override var period: AggregationPeriod? = null
        override var profilingGroupName: String? = null
        override var startTime: Instant? = null

        constructor(x: ListProfileTimesRequest) : this() {
            this.endTime = x.endTime
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.orderBy = x.orderBy
            this.period = x.period
            this.profilingGroupName = x.profilingGroupName
            this.startTime = x.startTime
        }

        override fun build(): ListProfileTimesRequest = ListProfileTimesRequest(this)
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun orderBy(orderBy: OrderBy): FluentBuilder = apply { this.orderBy = orderBy }
        override fun period(period: AggregationPeriod): FluentBuilder = apply { this.period = period }
        override fun profilingGroupName(profilingGroupName: String): FluentBuilder = apply { this.profilingGroupName = profilingGroupName }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
    }
}
