// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The structure representing the ListFindingsReportsRequest.
 */
class ListFindingsReportsRequest private constructor(builder: BuilderImpl) {
    /**
     * A Boolean value indicating whether to only return reports from daily profiles. If set
     * to True, only analysis data from daily profiles is returned. If set to False,
     * analysis data is returned from smaller time windows (for example, one hour).
     */
    val dailyReportsOnly: Boolean? = builder.dailyReportsOnly
    /**
     * The end time of the profile to get analysis data about. You must specify startTime and endTime.
     * This is specified
     * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
     * millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The maximum number of report results returned by ListFindingsReports
     * in paginated output. When this parameter is used, ListFindingsReports only returns
     * maxResults results in a single page along with a nextToken response
     * element. The remaining results of the initial request
     * can be seen by sending another ListFindingsReports request with the returned
     * nextToken value.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The nextToken value returned from a previous paginated ListFindingsReportsRequest
     * request where maxResults was used and the results exceeded the value of that parameter.
     * Pagination continues from the end of the previous results that returned the nextToken value.
     * This token should be treated as an opaque identifier that is only used to retrieve
     * the next items in a list and not for other programmatic purposes.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The name of the profiling group from which to search for analysis data.
     */
    val profilingGroupName: String? = builder.profilingGroupName
    /**
     * The start time of the profile to get analysis data about. You must specify startTime and endTime.
     * This is specified
     * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
     * millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    val startTime: Instant? = builder.startTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListFindingsReportsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListFindingsReportsRequest(")
        append("dailyReportsOnly=$dailyReportsOnly,")
        append("endTime=$endTime,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("profilingGroupName=$profilingGroupName,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dailyReportsOnly?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (profilingGroupName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListFindingsReportsRequest

        if (dailyReportsOnly != other.dailyReportsOnly) return false
        if (endTime != other.endTime) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (profilingGroupName != other.profilingGroupName) return false
        if (startTime != other.startTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListFindingsReportsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListFindingsReportsRequest
        /**
         * A Boolean value indicating whether to only return reports from daily profiles. If set
         * to True, only analysis data from daily profiles is returned. If set to False,
         * analysis data is returned from smaller time windows (for example, one hour).
         */
        fun dailyReportsOnly(dailyReportsOnly: Boolean): FluentBuilder
        /**
         * The end time of the profile to get analysis data about. You must specify startTime and endTime.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The maximum number of report results returned by ListFindingsReports
         * in paginated output. When this parameter is used, ListFindingsReports only returns
         * maxResults results in a single page along with a nextToken response
         * element. The remaining results of the initial request
         * can be seen by sending another ListFindingsReports request with the returned
         * nextToken value.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The nextToken value returned from a previous paginated ListFindingsReportsRequest
         * request where maxResults was used and the results exceeded the value of that parameter.
         * Pagination continues from the end of the previous results that returned the nextToken value.
         * This token should be treated as an opaque identifier that is only used to retrieve
         * the next items in a list and not for other programmatic purposes.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The name of the profiling group from which to search for analysis data.
         */
        fun profilingGroupName(profilingGroupName: String): FluentBuilder
        /**
         * The start time of the profile to get analysis data about. You must specify startTime and endTime.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        fun startTime(startTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A Boolean value indicating whether to only return reports from daily profiles. If set
         * to True, only analysis data from daily profiles is returned. If set to False,
         * analysis data is returned from smaller time windows (for example, one hour).
         */
        var dailyReportsOnly: Boolean?
        /**
         * The end time of the profile to get analysis data about. You must specify startTime and endTime.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        var endTime: Instant?
        /**
         * The maximum number of report results returned by ListFindingsReports
         * in paginated output. When this parameter is used, ListFindingsReports only returns
         * maxResults results in a single page along with a nextToken response
         * element. The remaining results of the initial request
         * can be seen by sending another ListFindingsReports request with the returned
         * nextToken value.
         */
        var maxResults: Int?
        /**
         * The nextToken value returned from a previous paginated ListFindingsReportsRequest
         * request where maxResults was used and the results exceeded the value of that parameter.
         * Pagination continues from the end of the previous results that returned the nextToken value.
         * This token should be treated as an opaque identifier that is only used to retrieve
         * the next items in a list and not for other programmatic purposes.
         */
        var nextToken: String?
        /**
         * The name of the profiling group from which to search for analysis data.
         */
        var profilingGroupName: String?
        /**
         * The start time of the profile to get analysis data about. You must specify startTime and endTime.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        var startTime: Instant?

        fun build(): ListFindingsReportsRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dailyReportsOnly: Boolean? = null
        override var endTime: Instant? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var profilingGroupName: String? = null
        override var startTime: Instant? = null

        constructor(x: ListFindingsReportsRequest) : this() {
            this.dailyReportsOnly = x.dailyReportsOnly
            this.endTime = x.endTime
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.profilingGroupName = x.profilingGroupName
            this.startTime = x.startTime
        }

        override fun build(): ListFindingsReportsRequest = ListFindingsReportsRequest(this)
        override fun dailyReportsOnly(dailyReportsOnly: Boolean): FluentBuilder = apply { this.dailyReportsOnly = dailyReportsOnly }
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun profilingGroupName(profilingGroupName: String): FluentBuilder = apply { this.profilingGroupName = profilingGroupName }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
    }
}
