// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The structure representing the getProfileRequest.
 */
class GetProfileRequest private constructor(builder: BuilderImpl) {
    /**
     * The format of the returned profiling data. The format maps to the
     * Accept and Content-Type headers of the
     * HTTP request. You can specify one of the following:
     * or the default .
     * application/json — standard JSON format
     * application/x-amzn-ion — the Amazon Ion data format. For more information,
     * see <a href="http://amzn.github.io/ion-docs/">Amazon Ion.
     */
    val accept: String? = builder.accept
    /**
     * The end time of the requested profile. Specify using
     * the ISO 8601 format. For example,
     * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * If you specify endTime, then you must also specify period
     * or startTime, but not both.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The maximum depth of the stacks in the code that is represented in
     * the aggregated profile. For example, if CodeGuru Profiler finds a method A,
     * which calls method B, which calls method C, which
     * calls method D, then the depth is 4. If the maxDepth is
     * set to 2, then the aggregated profile contains representations of methods A
     * and B.
     */
    val maxDepth: Int? = builder.maxDepth
    /**
     * Used with startTime or endTime to specify
     * the time range for the returned aggregated profile. Specify using
     * the ISO 8601 format. For example, P1DT1H1M1S.
     * To get the latest aggregated profile, specify only period.
     */
    val period: String? = builder.period
    /**
     * The name of the profiling group to get.
     */
    val profilingGroupName: String? = builder.profilingGroupName
    /**
     * The start time of the profile to get. Specify using
     * the ISO 8601 format. For example,
     * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     * If you specify startTime, then you must also specify period
     * or endTime, but not both.
     */
    val startTime: Instant? = builder.startTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetProfileRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetProfileRequest(")
        append("accept=$accept,")
        append("endTime=$endTime,")
        append("maxDepth=$maxDepth,")
        append("period=$period,")
        append("profilingGroupName=$profilingGroupName,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accept?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (maxDepth ?: 0)
        result = 31 * result + (period?.hashCode() ?: 0)
        result = 31 * result + (profilingGroupName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetProfileRequest

        if (accept != other.accept) return false
        if (endTime != other.endTime) return false
        if (maxDepth != other.maxDepth) return false
        if (period != other.period) return false
        if (profilingGroupName != other.profilingGroupName) return false
        if (startTime != other.startTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetProfileRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetProfileRequest
        /**
         * The format of the returned profiling data. The format maps to the
         * Accept and Content-Type headers of the
         * HTTP request. You can specify one of the following:
         * or the default .
         * application/json — standard JSON format
         * application/x-amzn-ion — the Amazon Ion data format. For more information,
         * see <a href="http://amzn.github.io/ion-docs/">Amazon Ion.
         */
        fun accept(accept: String): FluentBuilder
        /**
         * The end time of the requested profile. Specify using
         * the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * If you specify endTime, then you must also specify period
         * or startTime, but not both.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The maximum depth of the stacks in the code that is represented in
         * the aggregated profile. For example, if CodeGuru Profiler finds a method A,
         * which calls method B, which calls method C, which
         * calls method D, then the depth is 4. If the maxDepth is
         * set to 2, then the aggregated profile contains representations of methods A
         * and B.
         */
        fun maxDepth(maxDepth: Int): FluentBuilder
        /**
         * Used with startTime or endTime to specify
         * the time range for the returned aggregated profile. Specify using
         * the ISO 8601 format. For example, P1DT1H1M1S.
         * To get the latest aggregated profile, specify only period.
         */
        fun period(period: String): FluentBuilder
        /**
         * The name of the profiling group to get.
         */
        fun profilingGroupName(profilingGroupName: String): FluentBuilder
        /**
         * The start time of the profile to get. Specify using
         * the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * If you specify startTime, then you must also specify period
         * or endTime, but not both.
         */
        fun startTime(startTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The format of the returned profiling data. The format maps to the
         * Accept and Content-Type headers of the
         * HTTP request. You can specify one of the following:
         * or the default .
         * application/json — standard JSON format
         * application/x-amzn-ion — the Amazon Ion data format. For more information,
         * see <a href="http://amzn.github.io/ion-docs/">Amazon Ion.
         */
        var accept: String?
        /**
         * The end time of the requested profile. Specify using
         * the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * If you specify endTime, then you must also specify period
         * or startTime, but not both.
         */
        var endTime: Instant?
        /**
         * The maximum depth of the stacks in the code that is represented in
         * the aggregated profile. For example, if CodeGuru Profiler finds a method A,
         * which calls method B, which calls method C, which
         * calls method D, then the depth is 4. If the maxDepth is
         * set to 2, then the aggregated profile contains representations of methods A
         * and B.
         */
        var maxDepth: Int?
        /**
         * Used with startTime or endTime to specify
         * the time range for the returned aggregated profile. Specify using
         * the ISO 8601 format. For example, P1DT1H1M1S.
         * To get the latest aggregated profile, specify only period.
         */
        var period: String?
        /**
         * The name of the profiling group to get.
         */
        var profilingGroupName: String?
        /**
         * The start time of the profile to get. Specify using
         * the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         * If you specify startTime, then you must also specify period
         * or endTime, but not both.
         */
        var startTime: Instant?

        fun build(): GetProfileRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accept: String? = null
        override var endTime: Instant? = null
        override var maxDepth: Int? = null
        override var period: String? = null
        override var profilingGroupName: String? = null
        override var startTime: Instant? = null

        constructor(x: GetProfileRequest) : this() {
            this.accept = x.accept
            this.endTime = x.endTime
            this.maxDepth = x.maxDepth
            this.period = x.period
            this.profilingGroupName = x.profilingGroupName
            this.startTime = x.startTime
        }

        override fun build(): GetProfileRequest = GetProfileRequest(this)
        override fun accept(accept: String): FluentBuilder = apply { this.accept = accept }
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun maxDepth(maxDepth: Int): FluentBuilder = apply { this.maxDepth = maxDepth }
        override fun period(period: String): FluentBuilder = apply { this.period = period }
        override fun profilingGroupName(profilingGroupName: String): FluentBuilder = apply { this.profilingGroupName = profilingGroupName }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
    }
}
