// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * The structure representing the GetFindingsReportAccountSummaryRequest.
 */
class GetFindingsReportAccountSummaryRequest private constructor(builder: BuilderImpl) {
    /**
     * A Boolean value indicating whether to only return reports from daily profiles. If set
     * to True, only analysis data from daily profiles is returned. If set to False,
     * analysis data is returned from smaller time windows (for example, one hour).
     */
    val dailyReportsOnly: Boolean? = builder.dailyReportsOnly
    /**
     * The maximum number of results returned by  GetFindingsReportAccountSummary in paginated output.
     * When this parameter is used, GetFindingsReportAccountSummary only returns maxResults
     * results in a single page along with a nextToken response element. The remaining results of the initial
     * request can be seen by sending another GetFindingsReportAccountSummary request with the returned
     * nextToken value.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * The nextToken value returned from a previous paginated GetFindingsReportAccountSummary
     * request where maxResults was used and the results exceeded the value of that parameter.
     * Pagination continues from the end of the previous results that returned the nextToken value.
     * This token should be treated as an opaque identifier that is only used to retrieve
     * the next items in a list and not for other programmatic purposes.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetFindingsReportAccountSummaryRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetFindingsReportAccountSummaryRequest(")
        append("dailyReportsOnly=$dailyReportsOnly,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dailyReportsOnly?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetFindingsReportAccountSummaryRequest

        if (dailyReportsOnly != other.dailyReportsOnly) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetFindingsReportAccountSummaryRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetFindingsReportAccountSummaryRequest
        /**
         * A Boolean value indicating whether to only return reports from daily profiles. If set
         * to True, only analysis data from daily profiles is returned. If set to False,
         * analysis data is returned from smaller time windows (for example, one hour).
         */
        fun dailyReportsOnly(dailyReportsOnly: Boolean): FluentBuilder
        /**
         * The maximum number of results returned by  GetFindingsReportAccountSummary in paginated output.
         * When this parameter is used, GetFindingsReportAccountSummary only returns maxResults
         * results in a single page along with a nextToken response element. The remaining results of the initial
         * request can be seen by sending another GetFindingsReportAccountSummary request with the returned
         * nextToken value.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * The nextToken value returned from a previous paginated GetFindingsReportAccountSummary
         * request where maxResults was used and the results exceeded the value of that parameter.
         * Pagination continues from the end of the previous results that returned the nextToken value.
         * This token should be treated as an opaque identifier that is only used to retrieve
         * the next items in a list and not for other programmatic purposes.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A Boolean value indicating whether to only return reports from daily profiles. If set
         * to True, only analysis data from daily profiles is returned. If set to False,
         * analysis data is returned from smaller time windows (for example, one hour).
         */
        var dailyReportsOnly: Boolean?
        /**
         * The maximum number of results returned by  GetFindingsReportAccountSummary in paginated output.
         * When this parameter is used, GetFindingsReportAccountSummary only returns maxResults
         * results in a single page along with a nextToken response element. The remaining results of the initial
         * request can be seen by sending another GetFindingsReportAccountSummary request with the returned
         * nextToken value.
         */
        var maxResults: Int?
        /**
         * The nextToken value returned from a previous paginated GetFindingsReportAccountSummary
         * request where maxResults was used and the results exceeded the value of that parameter.
         * Pagination continues from the end of the previous results that returned the nextToken value.
         * This token should be treated as an opaque identifier that is only used to retrieve
         * the next items in a list and not for other programmatic purposes.
         */
        var nextToken: String?

        fun build(): GetFindingsReportAccountSummaryRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dailyReportsOnly: Boolean? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null

        constructor(x: GetFindingsReportAccountSummaryRequest) : this() {
            this.dailyReportsOnly = x.dailyReportsOnly
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): GetFindingsReportAccountSummaryRequest = GetFindingsReportAccountSummaryRequest(this)
        override fun dailyReportsOnly(dailyReportsOnly: Boolean): FluentBuilder = apply { this.dailyReportsOnly = dailyReportsOnly }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
