// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * The frame name, metric type, and thread states. These are used
 * to derive the value of the metric for the frame.
 */
class FrameMetric private constructor(builder: BuilderImpl) {
    /**
     * Name of the method common across the multiple occurrences of a frame in an application
     * profile.
     */
    val frameName: String? = builder.frameName
    /**
     * List of application runtime thread states used to get the counts for a frame a derive a metric value.
     */
    val threadStates: List<String>? = builder.threadStates
    /**
     * A type of aggregation that specifies how a metric for a frame is analyzed. The
     * supported value AggregatedRelativeTotalTime is an aggregation of the metric
     * value for one frame that is calculated across the occurrences of all frames in a profile.
     */
    val type: MetricType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FrameMetric = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FrameMetric(")
        append("frameName=$frameName,")
        append("threadStates=$threadStates,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = frameName?.hashCode() ?: 0
        result = 31 * result + (threadStates?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FrameMetric

        if (frameName != other.frameName) return false
        if (threadStates != other.threadStates) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FrameMetric = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FrameMetric
        /**
         * Name of the method common across the multiple occurrences of a frame in an application
         * profile.
         */
        fun frameName(frameName: String): FluentBuilder
        /**
         * List of application runtime thread states used to get the counts for a frame a derive a metric value.
         */
        fun threadStates(threadStates: List<String>): FluentBuilder
        /**
         * A type of aggregation that specifies how a metric for a frame is analyzed. The
         * supported value AggregatedRelativeTotalTime is an aggregation of the metric
         * value for one frame that is calculated across the occurrences of all frames in a profile.
         */
        fun type(type: MetricType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Name of the method common across the multiple occurrences of a frame in an application
         * profile.
         */
        var frameName: String?
        /**
         * List of application runtime thread states used to get the counts for a frame a derive a metric value.
         */
        var threadStates: List<String>?
        /**
         * A type of aggregation that specifies how a metric for a frame is analyzed. The
         * supported value AggregatedRelativeTotalTime is an aggregation of the metric
         * value for one frame that is calculated across the occurrences of all frames in a profile.
         */
        var type: MetricType?

        fun build(): FrameMetric
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var frameName: String? = null
        override var threadStates: List<String>? = null
        override var type: MetricType? = null

        constructor(x: FrameMetric) : this() {
            this.frameName = x.frameName
            this.threadStates = x.threadStates
            this.type = x.type
        }

        override fun build(): FrameMetric = FrameMetric(this)
        override fun frameName(frameName: String): FluentBuilder = apply { this.frameName = frameName }
        override fun threadStates(threadStates: List<String>): FluentBuilder = apply { this.threadStates = threadStates }
        override fun type(type: MetricType): FluentBuilder = apply { this.type = type }
    }
}
