// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * The structure representing the createProfiliingGroupRequest.
 */
class CreateProfilingGroupRequest private constructor(builder: BuilderImpl) {
    /**
     * Specifies whether profiling is enabled or disabled for the created profiling group.
     */
    val agentOrchestrationConfig: AgentOrchestrationConfig? = builder.agentOrchestrationConfig
    /**
     * Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the
     * accidental creation of duplicate profiling groups if there are failures and retries.
     */
    val clientToken: String? = builder.clientToken
    /**
     * The compute platform of the profiling group. Use AWSLambda if your application
     * runs on AWS Lambda. Use Default if your application runs on a compute platform that
     * is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different platform.
     * If not specified, Default is used.
     */
    val computePlatform: ComputePlatform? = builder.computePlatform
    /**
     * The name of the profiling group to create.
     */
    val profilingGroupName: String? = builder.profilingGroupName
    /**
     * A list of tags to add to the created profiling group.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateProfilingGroupRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateProfilingGroupRequest(")
        append("agentOrchestrationConfig=$agentOrchestrationConfig,")
        append("clientToken=$clientToken,")
        append("computePlatform=$computePlatform,")
        append("profilingGroupName=$profilingGroupName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentOrchestrationConfig?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (computePlatform?.hashCode() ?: 0)
        result = 31 * result + (profilingGroupName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateProfilingGroupRequest

        if (agentOrchestrationConfig != other.agentOrchestrationConfig) return false
        if (clientToken != other.clientToken) return false
        if (computePlatform != other.computePlatform) return false
        if (profilingGroupName != other.profilingGroupName) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateProfilingGroupRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateProfilingGroupRequest
        /**
         * Specifies whether profiling is enabled or disabled for the created profiling group.
         */
        fun agentOrchestrationConfig(agentOrchestrationConfig: AgentOrchestrationConfig): FluentBuilder
        /**
         * Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the
         * accidental creation of duplicate profiling groups if there are failures and retries.
         */
        fun clientToken(clientToken: String): FluentBuilder
        /**
         * The compute platform of the profiling group. Use AWSLambda if your application
         * runs on AWS Lambda. Use Default if your application runs on a compute platform that
         * is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different platform.
         * If not specified, Default is used.
         */
        fun computePlatform(computePlatform: ComputePlatform): FluentBuilder
        /**
         * The name of the profiling group to create.
         */
        fun profilingGroupName(profilingGroupName: String): FluentBuilder
        /**
         * A list of tags to add to the created profiling group.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Specifies whether profiling is enabled or disabled for the created profiling group.
         */
        var agentOrchestrationConfig: AgentOrchestrationConfig?
        /**
         * Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the
         * accidental creation of duplicate profiling groups if there are failures and retries.
         */
        var clientToken: String?
        /**
         * The compute platform of the profiling group. Use AWSLambda if your application
         * runs on AWS Lambda. Use Default if your application runs on a compute platform that
         * is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different platform.
         * If not specified, Default is used.
         */
        var computePlatform: ComputePlatform?
        /**
         * The name of the profiling group to create.
         */
        var profilingGroupName: String?
        /**
         * A list of tags to add to the created profiling group.
         */
        var tags: Map<String, String>?

        fun build(): CreateProfilingGroupRequest
        /**
         * construct an [aws.sdk.kotlin.services.codeguruprofiler.model.AgentOrchestrationConfig] inside the given [block]
         */
        fun agentOrchestrationConfig(block: AgentOrchestrationConfig.DslBuilder.() -> kotlin.Unit) {
            this.agentOrchestrationConfig = AgentOrchestrationConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var agentOrchestrationConfig: AgentOrchestrationConfig? = null
        override var clientToken: String? = null
        override var computePlatform: ComputePlatform? = null
        override var profilingGroupName: String? = null
        override var tags: Map<String, String>? = null

        constructor(x: CreateProfilingGroupRequest) : this() {
            this.agentOrchestrationConfig = x.agentOrchestrationConfig
            this.clientToken = x.clientToken
            this.computePlatform = x.computePlatform
            this.profilingGroupName = x.profilingGroupName
            this.tags = x.tags
        }

        override fun build(): CreateProfilingGroupRequest = CreateProfilingGroupRequest(this)
        override fun agentOrchestrationConfig(agentOrchestrationConfig: AgentOrchestrationConfig): FluentBuilder = apply { this.agentOrchestrationConfig = agentOrchestrationConfig }
        override fun clientToken(clientToken: String): FluentBuilder = apply { this.clientToken = clientToken }
        override fun computePlatform(computePlatform: ComputePlatform): FluentBuilder = apply { this.computePlatform = computePlatform }
        override fun profilingGroupName(profilingGroupName: String): FluentBuilder = apply { this.profilingGroupName = profilingGroupName }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
