// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * The structure representing the configureAgentRequest.
 */
class ConfigureAgentRequest private constructor(builder: BuilderImpl) {
    /**
     * A universally unique identifier (UUID) for a profiling instance. For example, if the
     * profiling instance is an Amazon EC2 instance, it is the instance ID. If it is an AWS
     * Fargate container, it is the container's task ID.
     */
    val fleetInstanceId: String? = builder.fleetInstanceId
    /**
     * Metadata captured about the compute platform the agent is running on. It includes
     * information about sampling and reporting. The valid fields are:
     * COMPUTE_PLATFORM - The compute platform on which the agent is running
     * AGENT_ID - The ID for an agent instance.
     * AWS_REQUEST_ID - The AWS request ID of a Lambda invocation.
     * EXECUTION_ENVIRONMENT - The execution environment a Lambda function is running on.
     * LAMBDA_FUNCTION_ARN - The Amazon Resource Name (ARN) that is used to invoke a Lambda function.
     * LAMBDA_MEMORY_LIMIT_IN_MB - The memory allocated to a Lambda function.
     * LAMBDA_REMAINING_TIME_IN_MILLISECONDS - The time in milliseconds before execution of a Lambda function times out.
     * LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS - The time in milliseconds between two invocations of a Lambda function.
     * LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS - The time in milliseconds for the previous Lambda invocation.
     */
    val metadata: Map<String, String>? = builder.metadata
    /**
     * The name of the profiling group for which the configured agent is collecting profiling data.
     */
    val profilingGroupName: String? = builder.profilingGroupName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ConfigureAgentRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ConfigureAgentRequest(")
        append("fleetInstanceId=$fleetInstanceId,")
        append("metadata=$metadata,")
        append("profilingGroupName=$profilingGroupName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fleetInstanceId?.hashCode() ?: 0
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (profilingGroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ConfigureAgentRequest

        if (fleetInstanceId != other.fleetInstanceId) return false
        if (metadata != other.metadata) return false
        if (profilingGroupName != other.profilingGroupName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ConfigureAgentRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ConfigureAgentRequest
        /**
         * A universally unique identifier (UUID) for a profiling instance. For example, if the
         * profiling instance is an Amazon EC2 instance, it is the instance ID. If it is an AWS
         * Fargate container, it is the container's task ID.
         */
        fun fleetInstanceId(fleetInstanceId: String): FluentBuilder
        /**
         * Metadata captured about the compute platform the agent is running on. It includes
         * information about sampling and reporting. The valid fields are:
         * COMPUTE_PLATFORM - The compute platform on which the agent is running
         * AGENT_ID - The ID for an agent instance.
         * AWS_REQUEST_ID - The AWS request ID of a Lambda invocation.
         * EXECUTION_ENVIRONMENT - The execution environment a Lambda function is running on.
         * LAMBDA_FUNCTION_ARN - The Amazon Resource Name (ARN) that is used to invoke a Lambda function.
         * LAMBDA_MEMORY_LIMIT_IN_MB - The memory allocated to a Lambda function.
         * LAMBDA_REMAINING_TIME_IN_MILLISECONDS - The time in milliseconds before execution of a Lambda function times out.
         * LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS - The time in milliseconds between two invocations of a Lambda function.
         * LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS - The time in milliseconds for the previous Lambda invocation.
         */
        fun metadata(metadata: Map<String, String>): FluentBuilder
        /**
         * The name of the profiling group for which the configured agent is collecting profiling data.
         */
        fun profilingGroupName(profilingGroupName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A universally unique identifier (UUID) for a profiling instance. For example, if the
         * profiling instance is an Amazon EC2 instance, it is the instance ID. If it is an AWS
         * Fargate container, it is the container's task ID.
         */
        var fleetInstanceId: String?
        /**
         * Metadata captured about the compute platform the agent is running on. It includes
         * information about sampling and reporting. The valid fields are:
         * COMPUTE_PLATFORM - The compute platform on which the agent is running
         * AGENT_ID - The ID for an agent instance.
         * AWS_REQUEST_ID - The AWS request ID of a Lambda invocation.
         * EXECUTION_ENVIRONMENT - The execution environment a Lambda function is running on.
         * LAMBDA_FUNCTION_ARN - The Amazon Resource Name (ARN) that is used to invoke a Lambda function.
         * LAMBDA_MEMORY_LIMIT_IN_MB - The memory allocated to a Lambda function.
         * LAMBDA_REMAINING_TIME_IN_MILLISECONDS - The time in milliseconds before execution of a Lambda function times out.
         * LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS - The time in milliseconds between two invocations of a Lambda function.
         * LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS - The time in milliseconds for the previous Lambda invocation.
         */
        var metadata: Map<String, String>?
        /**
         * The name of the profiling group for which the configured agent is collecting profiling data.
         */
        var profilingGroupName: String?

        fun build(): ConfigureAgentRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var fleetInstanceId: String? = null
        override var metadata: Map<String, String>? = null
        override var profilingGroupName: String? = null

        constructor(x: ConfigureAgentRequest) : this() {
            this.fleetInstanceId = x.fleetInstanceId
            this.metadata = x.metadata
            this.profilingGroupName = x.profilingGroupName
        }

        override fun build(): ConfigureAgentRequest = ConfigureAgentRequest(this)
        override fun fleetInstanceId(fleetInstanceId: String): FluentBuilder = apply { this.fleetInstanceId = fleetInstanceId }
        override fun metadata(metadata: Map<String, String>): FluentBuilder = apply { this.metadata = metadata }
        override fun profilingGroupName(profilingGroupName: String): FluentBuilder = apply { this.profilingGroupName = profilingGroupName }
    }
}
