// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * Notification medium for users to get alerted for events that occur in application profile. We support SNS topic as a notification channel.
 */
class Channel private constructor(builder: BuilderImpl) {
    /**
     * List of publishers for different type of events that may be detected in an application from the profile. Anomaly detection is the only event publisher in Profiler.
     */
    val eventPublishers: Set<EventPublisher>? = builder.eventPublishers
    /**
     * Unique identifier for each Channel in the notification configuration of a Profiling Group. A random UUID for channelId is used when adding a channel to the notification configuration if not specified in the request.
     */
    val id: String? = builder.id
    /**
     * Unique arn of the resource to be used for notifications. We support a valid SNS topic arn as a channel uri.
     */
    val uri: String? = builder.uri

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Channel = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Channel(")
        append("eventPublishers=$eventPublishers,")
        append("id=$id,")
        append("uri=$uri)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventPublishers?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Channel

        if (eventPublishers != other.eventPublishers) return false
        if (id != other.id) return false
        if (uri != other.uri) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Channel = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Channel
        /**
         * List of publishers for different type of events that may be detected in an application from the profile. Anomaly detection is the only event publisher in Profiler.
         */
        fun eventPublishers(eventPublishers: Set<EventPublisher>): FluentBuilder
        /**
         * Unique identifier for each Channel in the notification configuration of a Profiling Group. A random UUID for channelId is used when adding a channel to the notification configuration if not specified in the request.
         */
        fun id(id: String): FluentBuilder
        /**
         * Unique arn of the resource to be used for notifications. We support a valid SNS topic arn as a channel uri.
         */
        fun uri(uri: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * List of publishers for different type of events that may be detected in an application from the profile. Anomaly detection is the only event publisher in Profiler.
         */
        var eventPublishers: Set<EventPublisher>?
        /**
         * Unique identifier for each Channel in the notification configuration of a Profiling Group. A random UUID for channelId is used when adding a channel to the notification configuration if not specified in the request.
         */
        var id: String?
        /**
         * Unique arn of the resource to be used for notifications. We support a valid SNS topic arn as a channel uri.
         */
        var uri: String?

        fun build(): Channel
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var eventPublishers: Set<EventPublisher>? = null
        override var id: String? = null
        override var uri: String? = null

        constructor(x: Channel) : this() {
            this.eventPublishers = x.eventPublishers
            this.id = x.id
            this.uri = x.uri
        }

        override fun build(): Channel = Channel(this)
        override fun eventPublishers(eventPublishers: Set<EventPublisher>): FluentBuilder = apply { this.eventPublishers = eventPublishers }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun uri(uri: String): FluentBuilder = apply { this.uri = uri }
    }
}
