// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The structure representing the BatchGetFrameMetricDataResponse.
 */
class BatchGetFrameMetricDataResponse private constructor(builder: BuilderImpl) {
    /**
     * The end time of the time period for the returned time series values.
     * This is specified
     * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
     * millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    val endTime: Instant? = builder.endTime
    /**
     * List of instances, or time steps, in the time series. For example, if the
     * period is one day (PT24H)), and the resolution
     * is five minutes (PT5M), then there are 288 endTimes in the
     * list that are each five minutes appart.
     */
    val endTimes: List<TimestampStructure>? = builder.endTimes
    /**
     * Details of the metrics to request a time series of values. The metric includes
     * the name of the frame, the aggregation type to calculate the metric value for the frame,
     * and the thread states to use to get the count for the metric value of the frame.
     */
    val frameMetricData: List<FrameMetricDatum>? = builder.frameMetricData
    /**
     * Resolution or granularity of the profile data used to generate the time series.
     * This is the value used to jump through time steps in a time series. There are 3 valid values.
     * P1D — 1 day
     * PT1H — 1 hour
     * PT5M — 5 minutes
     */
    val resolution: AggregationPeriod? = builder.resolution
    /**
     * The start time of the time period for the returned time series values.
     * This is specified
     * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
     * millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    val startTime: Instant? = builder.startTime
    /**
     * List of instances which remained unprocessed. This will create a missing time step in the list of end times.
     */
    val unprocessedEndTimes: Map<String, List<TimestampStructure>>? = builder.unprocessedEndTimes

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BatchGetFrameMetricDataResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BatchGetFrameMetricDataResponse(")
        append("endTime=$endTime,")
        append("endTimes=$endTimes,")
        append("frameMetricData=$frameMetricData,")
        append("resolution=$resolution,")
        append("startTime=$startTime,")
        append("unprocessedEndTimes=$unprocessedEndTimes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (endTimes?.hashCode() ?: 0)
        result = 31 * result + (frameMetricData?.hashCode() ?: 0)
        result = 31 * result + (resolution?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (unprocessedEndTimes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BatchGetFrameMetricDataResponse

        if (endTime != other.endTime) return false
        if (endTimes != other.endTimes) return false
        if (frameMetricData != other.frameMetricData) return false
        if (resolution != other.resolution) return false
        if (startTime != other.startTime) return false
        if (unprocessedEndTimes != other.unprocessedEndTimes) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BatchGetFrameMetricDataResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BatchGetFrameMetricDataResponse
        /**
         * The end time of the time period for the returned time series values.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * List of instances, or time steps, in the time series. For example, if the
         * period is one day (PT24H)), and the resolution
         * is five minutes (PT5M), then there are 288 endTimes in the
         * list that are each five minutes appart.
         */
        fun endTimes(endTimes: List<TimestampStructure>): FluentBuilder
        /**
         * Details of the metrics to request a time series of values. The metric includes
         * the name of the frame, the aggregation type to calculate the metric value for the frame,
         * and the thread states to use to get the count for the metric value of the frame.
         */
        fun frameMetricData(frameMetricData: List<FrameMetricDatum>): FluentBuilder
        /**
         * Resolution or granularity of the profile data used to generate the time series.
         * This is the value used to jump through time steps in a time series. There are 3 valid values.
         * P1D — 1 day
         * PT1H — 1 hour
         * PT5M — 5 minutes
         */
        fun resolution(resolution: AggregationPeriod): FluentBuilder
        /**
         * The start time of the time period for the returned time series values.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * List of instances which remained unprocessed. This will create a missing time step in the list of end times.
         */
        fun unprocessedEndTimes(unprocessedEndTimes: Map<String, List<TimestampStructure>>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The end time of the time period for the returned time series values.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        var endTime: Instant?
        /**
         * List of instances, or time steps, in the time series. For example, if the
         * period is one day (PT24H)), and the resolution
         * is five minutes (PT5M), then there are 288 endTimes in the
         * list that are each five minutes appart.
         */
        var endTimes: List<TimestampStructure>?
        /**
         * Details of the metrics to request a time series of values. The metric includes
         * the name of the frame, the aggregation type to calculate the metric value for the frame,
         * and the thread states to use to get the count for the metric value of the frame.
         */
        var frameMetricData: List<FrameMetricDatum>?
        /**
         * Resolution or granularity of the profile data used to generate the time series.
         * This is the value used to jump through time steps in a time series. There are 3 valid values.
         * P1D — 1 day
         * PT1H — 1 hour
         * PT5M — 5 minutes
         */
        var resolution: AggregationPeriod?
        /**
         * The start time of the time period for the returned time series values.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        var startTime: Instant?
        /**
         * List of instances which remained unprocessed. This will create a missing time step in the list of end times.
         */
        var unprocessedEndTimes: Map<String, List<TimestampStructure>>?

        fun build(): BatchGetFrameMetricDataResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var endTime: Instant? = null
        override var endTimes: List<TimestampStructure>? = null
        override var frameMetricData: List<FrameMetricDatum>? = null
        override var resolution: AggregationPeriod? = null
        override var startTime: Instant? = null
        override var unprocessedEndTimes: Map<String, List<TimestampStructure>>? = null

        constructor(x: BatchGetFrameMetricDataResponse) : this() {
            this.endTime = x.endTime
            this.endTimes = x.endTimes
            this.frameMetricData = x.frameMetricData
            this.resolution = x.resolution
            this.startTime = x.startTime
            this.unprocessedEndTimes = x.unprocessedEndTimes
        }

        override fun build(): BatchGetFrameMetricDataResponse = BatchGetFrameMetricDataResponse(this)
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun endTimes(endTimes: List<TimestampStructure>): FluentBuilder = apply { this.endTimes = endTimes }
        override fun frameMetricData(frameMetricData: List<FrameMetricDatum>): FluentBuilder = apply { this.frameMetricData = frameMetricData }
        override fun resolution(resolution: AggregationPeriod): FluentBuilder = apply { this.resolution = resolution }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun unprocessedEndTimes(unprocessedEndTimes: Map<String, List<TimestampStructure>>): FluentBuilder = apply { this.unprocessedEndTimes = unprocessedEndTimes }
    }
}
