// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The structure representing the BatchGetFrameMetricDataRequest.
 */
class BatchGetFrameMetricDataRequest private constructor(builder: BuilderImpl) {
    /**
     * The end time of the time period for the returned time series values.
     * This is specified
     * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
     * millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The details of the metrics that are used to request a time series of values. The metric includes
     * the name of the frame, the aggregation type to calculate the metric value for the
     * frame, and the thread states to use to get the count for the metric value of the frame.
     */
    val frameMetrics: List<FrameMetric>? = builder.frameMetrics
    /**
     * The duration of the frame metrics used to return the time series values.
     * Specify using the ISO 8601 format. The maximum period duration
     * is one day (PT24H or P1D).
     */
    val period: String? = builder.period
    /**
     * The name of the profiling group associated with the
     * the frame metrics used to return the time series values.
     */
    val profilingGroupName: String? = builder.profilingGroupName
    /**
     * The start time of the time period for the frame metrics used to return the time series values.
     * This is specified
     * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
     * millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    val startTime: Instant? = builder.startTime
    /**
     * The requested resolution of time steps for the returned time series of values.
     * If the requested target resolution is not available due to data not being retained we provide a best effort
     * result by falling back to the most granular available resolution after the target resolution.
     * There are 3 valid values.
     * P1D — 1 day
     * PT1H — 1 hour
     * PT5M — 5 minutes
     */
    val targetResolution: AggregationPeriod? = builder.targetResolution

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): BatchGetFrameMetricDataRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("BatchGetFrameMetricDataRequest(")
        append("endTime=$endTime,")
        append("frameMetrics=$frameMetrics,")
        append("period=$period,")
        append("profilingGroupName=$profilingGroupName,")
        append("startTime=$startTime,")
        append("targetResolution=$targetResolution)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (frameMetrics?.hashCode() ?: 0)
        result = 31 * result + (period?.hashCode() ?: 0)
        result = 31 * result + (profilingGroupName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (targetResolution?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as BatchGetFrameMetricDataRequest

        if (endTime != other.endTime) return false
        if (frameMetrics != other.frameMetrics) return false
        if (period != other.period) return false
        if (profilingGroupName != other.profilingGroupName) return false
        if (startTime != other.startTime) return false
        if (targetResolution != other.targetResolution) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): BatchGetFrameMetricDataRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): BatchGetFrameMetricDataRequest
        /**
         * The end time of the time period for the returned time series values.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The details of the metrics that are used to request a time series of values. The metric includes
         * the name of the frame, the aggregation type to calculate the metric value for the
         * frame, and the thread states to use to get the count for the metric value of the frame.
         */
        fun frameMetrics(frameMetrics: List<FrameMetric>): FluentBuilder
        /**
         * The duration of the frame metrics used to return the time series values.
         * Specify using the ISO 8601 format. The maximum period duration
         * is one day (PT24H or P1D).
         */
        fun period(period: String): FluentBuilder
        /**
         * The name of the profiling group associated with the
         * the frame metrics used to return the time series values.
         */
        fun profilingGroupName(profilingGroupName: String): FluentBuilder
        /**
         * The start time of the time period for the frame metrics used to return the time series values.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * The requested resolution of time steps for the returned time series of values.
         * If the requested target resolution is not available due to data not being retained we provide a best effort
         * result by falling back to the most granular available resolution after the target resolution.
         * There are 3 valid values.
         * P1D — 1 day
         * PT1H — 1 hour
         * PT5M — 5 minutes
         */
        fun targetResolution(targetResolution: AggregationPeriod): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The end time of the time period for the returned time series values.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        var endTime: Instant?
        /**
         * The details of the metrics that are used to request a time series of values. The metric includes
         * the name of the frame, the aggregation type to calculate the metric value for the
         * frame, and the thread states to use to get the count for the metric value of the frame.
         */
        var frameMetrics: List<FrameMetric>?
        /**
         * The duration of the frame metrics used to return the time series values.
         * Specify using the ISO 8601 format. The maximum period duration
         * is one day (PT24H or P1D).
         */
        var period: String?
        /**
         * The name of the profiling group associated with the
         * the frame metrics used to return the time series values.
         */
        var profilingGroupName: String?
        /**
         * The start time of the time period for the frame metrics used to return the time series values.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        var startTime: Instant?
        /**
         * The requested resolution of time steps for the returned time series of values.
         * If the requested target resolution is not available due to data not being retained we provide a best effort
         * result by falling back to the most granular available resolution after the target resolution.
         * There are 3 valid values.
         * P1D — 1 day
         * PT1H — 1 hour
         * PT5M — 5 minutes
         */
        var targetResolution: AggregationPeriod?

        fun build(): BatchGetFrameMetricDataRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var endTime: Instant? = null
        override var frameMetrics: List<FrameMetric>? = null
        override var period: String? = null
        override var profilingGroupName: String? = null
        override var startTime: Instant? = null
        override var targetResolution: AggregationPeriod? = null

        constructor(x: BatchGetFrameMetricDataRequest) : this() {
            this.endTime = x.endTime
            this.frameMetrics = x.frameMetrics
            this.period = x.period
            this.profilingGroupName = x.profilingGroupName
            this.startTime = x.startTime
            this.targetResolution = x.targetResolution
        }

        override fun build(): BatchGetFrameMetricDataRequest = BatchGetFrameMetricDataRequest(this)
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun frameMetrics(frameMetrics: List<FrameMetric>): FluentBuilder = apply { this.frameMetrics = frameMetrics }
        override fun period(period: String): FluentBuilder = apply { this.period = period }
        override fun profilingGroupName(profilingGroupName: String): FluentBuilder = apply { this.profilingGroupName = profilingGroupName }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun targetResolution(targetResolution: AggregationPeriod): FluentBuilder = apply { this.targetResolution = targetResolution }
    }
}
