// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The specific duration in which the metric is flagged as anomalous.
 */
class AnomalyInstance private constructor(builder: BuilderImpl) {
    /**
     * The end time of the period during which the metric is flagged as anomalous.
     * This is specified
     * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
     * millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The universally unique identifier (UUID) of an instance of an anomaly in a metric.
     */
    val id: String? = builder.id
    /**
     * The start time of the period during which the metric is flagged as anomalous.
     * This is specified
     * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
     * millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    val startTime: Instant? = builder.startTime
    /**
     * Feedback type on a specific instance of anomaly submitted by the user.
     */
    val userFeedback: UserFeedback? = builder.userFeedback

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AnomalyInstance = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AnomalyInstance(")
        append("endTime=$endTime,")
        append("id=$id,")
        append("startTime=$startTime,")
        append("userFeedback=$userFeedback)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (userFeedback?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AnomalyInstance

        if (endTime != other.endTime) return false
        if (id != other.id) return false
        if (startTime != other.startTime) return false
        if (userFeedback != other.userFeedback) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AnomalyInstance = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AnomalyInstance
        /**
         * The end time of the period during which the metric is flagged as anomalous.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The universally unique identifier (UUID) of an instance of an anomaly in a metric.
         */
        fun id(id: String): FluentBuilder
        /**
         * The start time of the period during which the metric is flagged as anomalous.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * Feedback type on a specific instance of anomaly submitted by the user.
         */
        fun userFeedback(userFeedback: UserFeedback): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The end time of the period during which the metric is flagged as anomalous.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        var endTime: Instant?
        /**
         * The universally unique identifier (UUID) of an instance of an anomaly in a metric.
         */
        var id: String?
        /**
         * The start time of the period during which the metric is flagged as anomalous.
         * This is specified
         * using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1
         * millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        var startTime: Instant?
        /**
         * Feedback type on a specific instance of anomaly submitted by the user.
         */
        var userFeedback: UserFeedback?

        fun build(): AnomalyInstance
        /**
         * construct an [aws.sdk.kotlin.services.codeguruprofiler.model.UserFeedback] inside the given [block]
         */
        fun userFeedback(block: UserFeedback.DslBuilder.() -> kotlin.Unit) {
            this.userFeedback = UserFeedback.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var endTime: Instant? = null
        override var id: String? = null
        override var startTime: Instant? = null
        override var userFeedback: UserFeedback? = null

        constructor(x: AnomalyInstance) : this() {
            this.endTime = x.endTime
            this.id = x.id
            this.startTime = x.startTime
            this.userFeedback = x.userFeedback
        }

        override fun build(): AnomalyInstance = AnomalyInstance(this)
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun userFeedback(userFeedback: UserFeedback): FluentBuilder = apply { this.userFeedback = userFeedback }
    }
}
