// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * Details about an anomaly in a specific metric of application profile. The anomaly is detected using
 * analysis of the metric data over a period of time.
 */
class Anomaly private constructor(builder: BuilderImpl) {
    /**
     * A list of the instances of the detected anomalies during the requested period.
     */
    val instances: List<AnomalyInstance>? = builder.instances
    /**
     * Details about the metric that the analysis used when it detected the anomaly.
     * The metric includes the name of the frame that was analyzed with the type and
     * thread states used to derive the metric value for that frame.
     */
    val metric: Metric? = builder.metric
    /**
     * The reason for which metric was flagged as anomalous.
     */
    val reason: String? = builder.reason

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Anomaly = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Anomaly(")
        append("instances=$instances,")
        append("metric=$metric,")
        append("reason=$reason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = instances?.hashCode() ?: 0
        result = 31 * result + (metric?.hashCode() ?: 0)
        result = 31 * result + (reason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Anomaly

        if (instances != other.instances) return false
        if (metric != other.metric) return false
        if (reason != other.reason) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Anomaly = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Anomaly
        /**
         * A list of the instances of the detected anomalies during the requested period.
         */
        fun instances(instances: List<AnomalyInstance>): FluentBuilder
        /**
         * Details about the metric that the analysis used when it detected the anomaly.
         * The metric includes the name of the frame that was analyzed with the type and
         * thread states used to derive the metric value for that frame.
         */
        fun metric(metric: Metric): FluentBuilder
        /**
         * The reason for which metric was flagged as anomalous.
         */
        fun reason(reason: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list of the instances of the detected anomalies during the requested period.
         */
        var instances: List<AnomalyInstance>?
        /**
         * Details about the metric that the analysis used when it detected the anomaly.
         * The metric includes the name of the frame that was analyzed with the type and
         * thread states used to derive the metric value for that frame.
         */
        var metric: Metric?
        /**
         * The reason for which metric was flagged as anomalous.
         */
        var reason: String?

        fun build(): Anomaly
        /**
         * construct an [aws.sdk.kotlin.services.codeguruprofiler.model.Metric] inside the given [block]
         */
        fun metric(block: Metric.DslBuilder.() -> kotlin.Unit) {
            this.metric = Metric.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var instances: List<AnomalyInstance>? = null
        override var metric: Metric? = null
        override var reason: String? = null

        constructor(x: Anomaly) : this() {
            this.instances = x.instances
            this.metric = x.metric
            this.reason = x.reason
        }

        override fun build(): Anomaly = Anomaly(this)
        override fun instances(instances: List<AnomalyInstance>): FluentBuilder = apply { this.instances = instances }
        override fun metric(metric: Metric): FluentBuilder = apply { this.metric = metric }
        override fun reason(reason: String): FluentBuilder = apply { this.reason = reason }
    }
}
