// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Specifies the aggregation period and aggregation start time for
 * an aggregated profile. An aggregated profile is used to collect posted agent profiles
 * during an aggregation period. There are three possible aggregation periods (1 day,
 * 1 hour, or 5 minutes).
 */
class AggregatedProfileTime private constructor(builder: BuilderImpl) {
    /**
     * The aggregation period. This indicates the period during which an aggregation profile
     * collects posted agent profiles for a profiling group. Use one of three valid
     * durations that are specified using the ISO 8601 format.
     * P1D — 1 day
     * PT1H — 1 hour
     * PT5M — 5 minutes
     */
    val period: AggregationPeriod? = builder.period
    /**
     * The time that aggregation of posted agent profiles for a profiling group starts. The aggregation profile
     * contains profiles posted by the agent starting at this time for an aggregation period
     * specified by the period property of the AggregatedProfileTime
     * object.
     * Specify start using the ISO 8601 format. For example,
     * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    val start: Instant? = builder.start

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AggregatedProfileTime = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AggregatedProfileTime(")
        append("period=$period,")
        append("start=$start)")
    }

    override fun hashCode(): kotlin.Int {
        var result = period?.hashCode() ?: 0
        result = 31 * result + (start?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AggregatedProfileTime

        if (period != other.period) return false
        if (start != other.start) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AggregatedProfileTime = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AggregatedProfileTime
        /**
         * The aggregation period. This indicates the period during which an aggregation profile
         * collects posted agent profiles for a profiling group. Use one of three valid
         * durations that are specified using the ISO 8601 format.
         * P1D — 1 day
         * PT1H — 1 hour
         * PT5M — 5 minutes
         */
        fun period(period: AggregationPeriod): FluentBuilder
        /**
         * The time that aggregation of posted agent profiles for a profiling group starts. The aggregation profile
         * contains profiles posted by the agent starting at this time for an aggregation period
         * specified by the period property of the AggregatedProfileTime
         * object.
         * Specify start using the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        fun start(start: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The aggregation period. This indicates the period during which an aggregation profile
         * collects posted agent profiles for a profiling group. Use one of three valid
         * durations that are specified using the ISO 8601 format.
         * P1D — 1 day
         * PT1H — 1 hour
         * PT5M — 5 minutes
         */
        var period: AggregationPeriod?
        /**
         * The time that aggregation of posted agent profiles for a profiling group starts. The aggregation profile
         * contains profiles posted by the agent starting at this time for an aggregation period
         * specified by the period property of the AggregatedProfileTime
         * object.
         * Specify start using the ISO 8601 format. For example,
         * 2020-06-01T13:15:02.001Z  represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        var start: Instant?

        fun build(): AggregatedProfileTime
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var period: AggregationPeriod? = null
        override var start: Instant? = null

        constructor(x: AggregatedProfileTime) : this() {
            this.period = x.period
            this.start = x.start
        }

        override fun build(): AggregatedProfileTime = AggregatedProfileTime(this)
        override fun period(period: AggregationPeriod): FluentBuilder = apply { this.period = period }
        override fun start(start: Instant): FluentBuilder = apply { this.start = start }
    }
}
