// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * The response of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
 * ConfigureAgent
 * that
 * specifies if an agent profiles or not and for how long to return profiling data.
 */
class AgentConfiguration private constructor(builder: BuilderImpl) {
    /**
     * Parameters used by the profiler. The valid parameters are:
     * MaxStackDepth - The maximum depth of the stacks in the code that is represented in
     * the profile. For example, if CodeGuru Profiler finds a method A,
     * which calls method B, which calls method C, which
     * calls method D, then the depth is 4. If the maxDepth is
     * set to 2, then the profiler evaluates A and B.
     * MemoryUsageLimitPercent - The percentage of memory that is used by the
     * profiler.
     * MinimumTimeForReportingInMilliseconds - The minimum time in milliseconds between
     * sending reports.
     * ReportingIntervalInMilliseconds - The reporting interval in milliseconds used
     * to report profiles.
     * SamplingIntervalInMilliseconds - The sampling interval in milliseconds that is used to
     * profile samples.
     */
    val agentParameters: Map<String, String>? = builder.agentParameters
    /**
     * How long a profiling agent should send profiling data using
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
     * ConfigureAgent
     * .
     * For example, if this is set to 300, the profiling agent calls <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
     * ConfigureAgent
     * every 5 minutes to submit the profiled data collected during that period.
     */
    val periodInSeconds: Int? = builder.periodInSeconds
    /**
     * A Boolean that specifies whether the profiling agent collects profiling data or not. Set to true
     * to enable profiling.
     */
    val shouldProfile: Boolean? = builder.shouldProfile

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AgentConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AgentConfiguration(")
        append("agentParameters=$agentParameters,")
        append("periodInSeconds=$periodInSeconds,")
        append("shouldProfile=$shouldProfile)")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentParameters?.hashCode() ?: 0
        result = 31 * result + (periodInSeconds ?: 0)
        result = 31 * result + (shouldProfile?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AgentConfiguration

        if (agentParameters != other.agentParameters) return false
        if (periodInSeconds != other.periodInSeconds) return false
        if (shouldProfile != other.shouldProfile) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AgentConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AgentConfiguration
        /**
         * Parameters used by the profiler. The valid parameters are:
         * MaxStackDepth - The maximum depth of the stacks in the code that is represented in
         * the profile. For example, if CodeGuru Profiler finds a method A,
         * which calls method B, which calls method C, which
         * calls method D, then the depth is 4. If the maxDepth is
         * set to 2, then the profiler evaluates A and B.
         * MemoryUsageLimitPercent - The percentage of memory that is used by the
         * profiler.
         * MinimumTimeForReportingInMilliseconds - The minimum time in milliseconds between
         * sending reports.
         * ReportingIntervalInMilliseconds - The reporting interval in milliseconds used
         * to report profiles.
         * SamplingIntervalInMilliseconds - The sampling interval in milliseconds that is used to
         * profile samples.
         */
        fun agentParameters(agentParameters: Map<String, String>): FluentBuilder
        /**
         * How long a profiling agent should send profiling data using
         * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
         * ConfigureAgent
         * .
         * For example, if this is set to 300, the profiling agent calls <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
         * ConfigureAgent
         * every 5 minutes to submit the profiled data collected during that period.
         */
        fun periodInSeconds(periodInSeconds: Int): FluentBuilder
        /**
         * A Boolean that specifies whether the profiling agent collects profiling data or not. Set to true
         * to enable profiling.
         */
        fun shouldProfile(shouldProfile: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Parameters used by the profiler. The valid parameters are:
         * MaxStackDepth - The maximum depth of the stacks in the code that is represented in
         * the profile. For example, if CodeGuru Profiler finds a method A,
         * which calls method B, which calls method C, which
         * calls method D, then the depth is 4. If the maxDepth is
         * set to 2, then the profiler evaluates A and B.
         * MemoryUsageLimitPercent - The percentage of memory that is used by the
         * profiler.
         * MinimumTimeForReportingInMilliseconds - The minimum time in milliseconds between
         * sending reports.
         * ReportingIntervalInMilliseconds - The reporting interval in milliseconds used
         * to report profiles.
         * SamplingIntervalInMilliseconds - The sampling interval in milliseconds that is used to
         * profile samples.
         */
        var agentParameters: Map<String, String>?
        /**
         * How long a profiling agent should send profiling data using
         * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
         * ConfigureAgent
         * .
         * For example, if this is set to 300, the profiling agent calls <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
         * ConfigureAgent
         * every 5 minutes to submit the profiled data collected during that period.
         */
        var periodInSeconds: Int?
        /**
         * A Boolean that specifies whether the profiling agent collects profiling data or not. Set to true
         * to enable profiling.
         */
        var shouldProfile: Boolean?

        fun build(): AgentConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var agentParameters: Map<String, String>? = null
        override var periodInSeconds: Int? = null
        override var shouldProfile: Boolean? = null

        constructor(x: AgentConfiguration) : this() {
            this.agentParameters = x.agentParameters
            this.periodInSeconds = x.periodInSeconds
            this.shouldProfile = x.shouldProfile
        }

        override fun build(): AgentConfiguration = AgentConfiguration(this)
        override fun agentParameters(agentParameters: Map<String, String>): FluentBuilder = apply { this.agentParameters = agentParameters }
        override fun periodInSeconds(periodInSeconds: Int): FluentBuilder = apply { this.periodInSeconds = periodInSeconds }
        override fun shouldProfile(shouldProfile: Boolean): FluentBuilder = apply { this.shouldProfile = shouldProfile }
    }
}
