// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.services.codeguruprofiler.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.codeguruprofiler.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * This section provides documentation for the Amazon CodeGuru Profiler API operations.
 * Amazon CodeGuru Profiler collects runtime performance data from your live applications, and provides
 * recommendations that can help you fine-tune your application performance. Using machine learning
 * algorithms, CodeGuru Profiler can help you find your most expensive lines of code and suggest ways you can
 * improve efficiency and remove CPU bottlenecks.
 * Amazon CodeGuru Profiler provides different visualizations of profiling data to help you identify what code is
 * running on the CPU, see how much time is consumed, and suggest ways to reduce CPU utilization.
 * Amazon CodeGuru Profiler currently supports applications written in all Java virtual machine (JVM)
 * languages and Python. While CodeGuru Profiler supports both visualizations and recommendations for applications
 * written in Java, it can also generate visualizations and a subset of recommendations for
 * applications written in other JVM languages and Python.
 * For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/what-is-codeguru-profiler.html">What is Amazon CodeGuru Profiler in
 * the Amazon CodeGuru Profiler User Guide.
 */
interface CodeGuruProfilerClient : SdkClient {

    override val serviceName: String
        get() = "CodeGuruProfiler"
    /**
     * CodeGuruProfilerClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): CodeGuruProfilerClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultCodeGuruProfilerClient(config)
        }

        operator fun invoke(config: Config): CodeGuruProfilerClient = DefaultCodeGuruProfilerClient(config)

        /**
         * Construct a [CodeGuruProfilerClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): CodeGuruProfilerClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return CodeGuruProfilerClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: EndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder = apply { this.idempotencyTokenProvider = idempotencyTokenProvider }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Add up to 2 anomaly notifications channels for a profiling group.
     */
    suspend fun addNotificationChannels(input: AddNotificationChannelsRequest): AddNotificationChannelsResponse

    /**
     * Add up to 2 anomaly notifications channels for a profiling group.
     */
    suspend fun addNotificationChannels(block: AddNotificationChannelsRequest.DslBuilder.() -> Unit) = addNotificationChannels(AddNotificationChannelsRequest.builder().apply(block).build())

    /**
     * Returns the time series of values for a requested list
     * of frame metrics from a time period.
     */
    suspend fun batchGetFrameMetricData(input: BatchGetFrameMetricDataRequest): BatchGetFrameMetricDataResponse

    /**
     * Returns the time series of values for a requested list
     * of frame metrics from a time period.
     */
    suspend fun batchGetFrameMetricData(block: BatchGetFrameMetricDataRequest.DslBuilder.() -> Unit) = batchGetFrameMetricData(BatchGetFrameMetricDataRequest.builder().apply(block).build())

    /**
     * Used by profiler agents to report their current state and to receive remote
     * configuration updates. For example, ConfigureAgent can be used
     * to tell an agent whether to profile or not and for how long to return profiling data.
     */
    suspend fun configureAgent(input: ConfigureAgentRequest): ConfigureAgentResponse

    /**
     * Used by profiler agents to report their current state and to receive remote
     * configuration updates. For example, ConfigureAgent can be used
     * to tell an agent whether to profile or not and for how long to return profiling data.
     */
    suspend fun configureAgent(block: ConfigureAgentRequest.DslBuilder.() -> Unit) = configureAgent(ConfigureAgentRequest.builder().apply(block).build())

    /**
     * Creates a profiling group.
     */
    suspend fun createProfilingGroup(input: CreateProfilingGroupRequest): CreateProfilingGroupResponse

    /**
     * Creates a profiling group.
     */
    suspend fun createProfilingGroup(block: CreateProfilingGroupRequest.DslBuilder.() -> Unit) = createProfilingGroup(CreateProfilingGroupRequest.builder().apply(block).build())

    /**
     * Deletes a profiling group.
     */
    suspend fun deleteProfilingGroup(input: DeleteProfilingGroupRequest): DeleteProfilingGroupResponse

    /**
     * Deletes a profiling group.
     */
    suspend fun deleteProfilingGroup(block: DeleteProfilingGroupRequest.DslBuilder.() -> Unit) = deleteProfilingGroup(DeleteProfilingGroupRequest.builder().apply(block).build())

    /**
     * Returns a <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     * ProfilingGroupDescription
     * object that contains information about the requested profiling group.
     */
    suspend fun describeProfilingGroup(input: DescribeProfilingGroupRequest): DescribeProfilingGroupResponse

    /**
     * Returns a <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     * ProfilingGroupDescription
     * object that contains information about the requested profiling group.
     */
    suspend fun describeProfilingGroup(block: DescribeProfilingGroupRequest.DslBuilder.() -> Unit) = describeProfilingGroup(DescribeProfilingGroupRequest.builder().apply(block).build())

    /**
     * Returns a list of
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html">
     * FindingsReportSummary
     * objects that contain analysis results for all profiling groups in your AWS account.
     */
    suspend fun getFindingsReportAccountSummary(input: GetFindingsReportAccountSummaryRequest): GetFindingsReportAccountSummaryResponse

    /**
     * Returns a list of
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html">
     * FindingsReportSummary
     * objects that contain analysis results for all profiling groups in your AWS account.
     */
    suspend fun getFindingsReportAccountSummary(block: GetFindingsReportAccountSummaryRequest.DslBuilder.() -> Unit) = getFindingsReportAccountSummary(GetFindingsReportAccountSummaryRequest.builder().apply(block).build())

    /**
     * Get the current configuration for anomaly notifications for a profiling group.
     */
    suspend fun getNotificationConfiguration(input: GetNotificationConfigurationRequest): GetNotificationConfigurationResponse

    /**
     * Get the current configuration for anomaly notifications for a profiling group.
     */
    suspend fun getNotificationConfiguration(block: GetNotificationConfigurationRequest.DslBuilder.() -> Unit) = getNotificationConfiguration(GetNotificationConfigurationRequest.builder().apply(block).build())

    /**
     * Returns the JSON-formatted resource-based policy on a profiling group.
     */
    suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse

    /**
     * Returns the JSON-formatted resource-based policy on a profiling group.
     */
    suspend fun getPolicy(block: GetPolicyRequest.DslBuilder.() -> Unit) = getPolicy(GetPolicyRequest.builder().apply(block).build())

    /**
     * Gets the aggregated profile of a profiling group for a specified time range.
     * Amazon CodeGuru Profiler collects posted agent profiles for a profiling group
     * into aggregated profiles.
     * Because aggregated profiles expire over time GetProfile is not idempotent.
     * Specify the time range for the requested aggregated profile using 1 or 2 of the following parameters: startTime,
     * endTime, period. The maximum time range allowed is 7 days. If you specify all 3 parameters,
     * an exception is thrown. If you specify only period, the latest aggregated profile is returned.
     * Aggregated profiles are available with aggregation periods of 5 minutes, 1 hour, and 1 day, aligned to
     * UTC. The aggregation period of an aggregated profile determines how long it is retained. For more
     * information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html">
     * AggregatedProfileTime
     * . The aggregated profile's aggregation period determines how long
     * it is retained by CodeGuru Profiler.
     * If the aggregation period is 5 minutes, the aggregated profile is retained for 15 days.
     * If the aggregation period is 1 hour, the aggregated profile is retained for 60 days.
     * If the aggregation period is 1 day, the aggregated profile is retained for 3 years.
     * There are two use cases for calling GetProfile.
     * <ol>
     * If you want to return an aggregated profile that already exists, use
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ListProfileTimes.html">
     * ListProfileTimes
     * to
     * view the time ranges of existing aggregated profiles. Use them in a GetProfile request to return a specific,
     * existing aggregated profile.
     * If you want to return an aggregated profile for a time range that doesn't align with an existing aggregated profile,
     * then CodeGuru Profiler makes a best effort to combine existing aggregated profiles from the requested time
     * range and return them as one aggregated profile.
     * If aggregated profiles do not exist for the full time range requested, then
     * aggregated profiles for a smaller time range are returned. For example, if the
     * requested time range is from 00:00 to 00:20, and the existing aggregated profiles are
     * from 00:15 and 00:25, then the aggregated profiles from 00:15 to 00:20 are returned.
     * </ol>
     */
    suspend fun getProfile(input: GetProfileRequest): GetProfileResponse

    /**
     * Gets the aggregated profile of a profiling group for a specified time range.
     * Amazon CodeGuru Profiler collects posted agent profiles for a profiling group
     * into aggregated profiles.
     * Because aggregated profiles expire over time GetProfile is not idempotent.
     * Specify the time range for the requested aggregated profile using 1 or 2 of the following parameters: startTime,
     * endTime, period. The maximum time range allowed is 7 days. If you specify all 3 parameters,
     * an exception is thrown. If you specify only period, the latest aggregated profile is returned.
     * Aggregated profiles are available with aggregation periods of 5 minutes, 1 hour, and 1 day, aligned to
     * UTC. The aggregation period of an aggregated profile determines how long it is retained. For more
     * information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html">
     * AggregatedProfileTime
     * . The aggregated profile's aggregation period determines how long
     * it is retained by CodeGuru Profiler.
     * If the aggregation period is 5 minutes, the aggregated profile is retained for 15 days.
     * If the aggregation period is 1 hour, the aggregated profile is retained for 60 days.
     * If the aggregation period is 1 day, the aggregated profile is retained for 3 years.
     * There are two use cases for calling GetProfile.
     * <ol>
     * If you want to return an aggregated profile that already exists, use
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ListProfileTimes.html">
     * ListProfileTimes
     * to
     * view the time ranges of existing aggregated profiles. Use them in a GetProfile request to return a specific,
     * existing aggregated profile.
     * If you want to return an aggregated profile for a time range that doesn't align with an existing aggregated profile,
     * then CodeGuru Profiler makes a best effort to combine existing aggregated profiles from the requested time
     * range and return them as one aggregated profile.
     * If aggregated profiles do not exist for the full time range requested, then
     * aggregated profiles for a smaller time range are returned. For example, if the
     * requested time range is from 00:00 to 00:20, and the existing aggregated profiles are
     * from 00:15 and 00:25, then the aggregated profiles from 00:15 to 00:20 are returned.
     * </ol>
     */
    suspend fun getProfile(block: GetProfileRequest.DslBuilder.() -> Unit) = getProfile(GetProfileRequest.builder().apply(block).build())

    /**
     * Returns a list of
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Recommendation.html">
     * Recommendation
     * objects that contain recommendations for a profiling group for a given time period. A list of
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Anomaly.html">
     * Anomaly
     * objects that contains details about anomalies detected in the profiling group for the same time period is also
     * returned.
     */
    suspend fun getRecommendations(input: GetRecommendationsRequest): GetRecommendationsResponse

    /**
     * Returns a list of
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Recommendation.html">
     * Recommendation
     * objects that contain recommendations for a profiling group for a given time period. A list of
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Anomaly.html">
     * Anomaly
     * objects that contains details about anomalies detected in the profiling group for the same time period is also
     * returned.
     */
    suspend fun getRecommendations(block: GetRecommendationsRequest.DslBuilder.() -> Unit) = getRecommendations(GetRecommendationsRequest.builder().apply(block).build())

    /**
     * List the available reports for a given profiling group and time range.
     */
    suspend fun listFindingsReports(input: ListFindingsReportsRequest): ListFindingsReportsResponse

    /**
     * List the available reports for a given profiling group and time range.
     */
    suspend fun listFindingsReports(block: ListFindingsReportsRequest.DslBuilder.() -> Unit) = listFindingsReports(ListFindingsReportsRequest.builder().apply(block).build())

    /**
     * Lists the start times of the available aggregated profiles of a profiling group
     * for an aggregation period within the specified time range.
     */
    suspend fun listProfileTimes(input: ListProfileTimesRequest): ListProfileTimesResponse

    /**
     * Lists the start times of the available aggregated profiles of a profiling group
     * for an aggregation period within the specified time range.
     */
    suspend fun listProfileTimes(block: ListProfileTimesRequest.DslBuilder.() -> Unit) = listProfileTimes(ListProfileTimesRequest.builder().apply(block).build())

    /**
     * Returns a list of profiling groups. The profiling groups are returned as
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     * ProfilingGroupDescription
     * objects.
     */
    suspend fun listProfilingGroups(input: ListProfilingGroupsRequest): ListProfilingGroupsResponse

    /**
     * Returns a list of profiling groups. The profiling groups are returned as
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html">
     * ProfilingGroupDescription
     * objects.
     */
    suspend fun listProfilingGroups(block: ListProfilingGroupsRequest.DslBuilder.() -> Unit) = listProfilingGroups(ListProfilingGroupsRequest.builder().apply(block).build())

    /**
     * Returns a list of the tags that are assigned to a specified resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of the tags that are assigned to a specified resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Submits profiling data to an aggregated profile of a profiling group. To get an
     * aggregated profile that is created with this profiling data, use
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetProfile.html">
     * GetProfile
     * .
     */
    suspend fun postAgentProfile(input: PostAgentProfileRequest): PostAgentProfileResponse

    /**
     * Submits profiling data to an aggregated profile of a profiling group. To get an
     * aggregated profile that is created with this profiling data, use
     * <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetProfile.html">
     * GetProfile
     * .
     */
    suspend fun postAgentProfile(block: PostAgentProfileRequest.DslBuilder.() -> Unit) = postAgentProfile(PostAgentProfileRequest.builder().apply(block).build())

    /**
     * Adds permissions to a profiling group's resource-based policy
     * that are provided using an action group. If a profiling group doesn't have
     * a resource-based policy, one is created for it using the permissions in the action group and
     * the roles and users in the principals parameter.
     * The one supported action group that can be added is agentPermission
     * which grants ConfigureAgent and PostAgent permissions. For
     * more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html">Resource-based
     * policies in CodeGuru Profiler in the Amazon CodeGuru Profiler User
     * Guide, <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
     * ConfigureAgent
     * , and <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html">
     * PostAgentProfile
     * .
     * The first time you call PutPermission on a profiling group, do not specify a revisionId because
     * it doesn't have a resource-based policy. Subsequent calls must provide a revisionId to specify
     * which revision of the resource-based policy to add the permissions to.
     * The response contains the profiling group's JSON-formatted resource policy.
     */
    suspend fun putPermission(input: PutPermissionRequest): PutPermissionResponse

    /**
     * Adds permissions to a profiling group's resource-based policy
     * that are provided using an action group. If a profiling group doesn't have
     * a resource-based policy, one is created for it using the permissions in the action group and
     * the roles and users in the principals parameter.
     * The one supported action group that can be added is agentPermission
     * which grants ConfigureAgent and PostAgent permissions. For
     * more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html">Resource-based
     * policies in CodeGuru Profiler in the Amazon CodeGuru Profiler User
     * Guide, <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
     * ConfigureAgent
     * , and <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html">
     * PostAgentProfile
     * .
     * The first time you call PutPermission on a profiling group, do not specify a revisionId because
     * it doesn't have a resource-based policy. Subsequent calls must provide a revisionId to specify
     * which revision of the resource-based policy to add the permissions to.
     * The response contains the profiling group's JSON-formatted resource policy.
     */
    suspend fun putPermission(block: PutPermissionRequest.DslBuilder.() -> Unit) = putPermission(PutPermissionRequest.builder().apply(block).build())

    /**
     * Remove one anomaly notifications channel for a profiling group.
     */
    suspend fun removeNotificationChannel(input: RemoveNotificationChannelRequest): RemoveNotificationChannelResponse

    /**
     * Remove one anomaly notifications channel for a profiling group.
     */
    suspend fun removeNotificationChannel(block: RemoveNotificationChannelRequest.DslBuilder.() -> Unit) = removeNotificationChannel(RemoveNotificationChannelRequest.builder().apply(block).build())

    /**
     * Removes permissions from a profiling group's resource-based policy that are provided
     * using an action group. The one supported action group that can be removed is
     * agentPermission which grants ConfigureAgent and
     * PostAgent permissions. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html">Resource-based policies in CodeGuru Profiler in the Amazon
     * CodeGuru Profiler User Guide, <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
     * ConfigureAgent
     * , and <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html">
     * PostAgentProfile
     * .
     */
    suspend fun removePermission(input: RemovePermissionRequest): RemovePermissionResponse

    /**
     * Removes permissions from a profiling group's resource-based policy that are provided
     * using an action group. The one supported action group that can be removed is
     * agentPermission which grants ConfigureAgent and
     * PostAgent permissions. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html">Resource-based policies in CodeGuru Profiler in the Amazon
     * CodeGuru Profiler User Guide, <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html">
     * ConfigureAgent
     * , and <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html">
     * PostAgentProfile
     * .
     */
    suspend fun removePermission(block: RemovePermissionRequest.DslBuilder.() -> Unit) = removePermission(RemovePermissionRequest.builder().apply(block).build())

    /**
     * Sends feedback to CodeGuru Profiler about whether the anomaly detected by the analysis is
     * useful or not.
     */
    suspend fun submitFeedback(input: SubmitFeedbackRequest): SubmitFeedbackResponse

    /**
     * Sends feedback to CodeGuru Profiler about whether the anomaly detected by the analysis is
     * useful or not.
     */
    suspend fun submitFeedback(block: SubmitFeedbackRequest.DslBuilder.() -> Unit) = submitFeedback(SubmitFeedbackRequest.builder().apply(block).build())

    /**
     * Use to assign one or more tags to a resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Use to assign one or more tags to a resource.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Use to remove one or more tags from a resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Use to remove one or more tags from a resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Updates a profiling group.
     */
    suspend fun updateProfilingGroup(input: UpdateProfilingGroupRequest): UpdateProfilingGroupResponse

    /**
     * Updates a profiling group.
     */
    suspend fun updateProfilingGroup(block: UpdateProfilingGroupRequest.DslBuilder.() -> Unit) = updateProfilingGroup(UpdateProfilingGroupRequest.builder().apply(block).build())
}
