// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.endpoints

import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.net.Url
import kotlin.test.*
import kotlinx.coroutines.test.runTest

public class DefaultEndpointProviderTest {
    // For region us-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test0() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.us-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test1() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.us-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test2() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.us-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test3() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.us-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS enabled and DualStack enabled
    @Test
    fun test4() = runTest {
        val params = EndpointParameters {
            region = "cn-north-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.cn-north-1.api.amazonwebservices.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS enabled and DualStack disabled
    @Test
    fun test5() = runTest {
        val params = EndpointParameters {
            region = "cn-north-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.cn-north-1.amazonaws.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS disabled and DualStack enabled
    @Test
    fun test6() = runTest {
        val params = EndpointParameters {
            region = "cn-north-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.cn-north-1.api.amazonwebservices.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS disabled and DualStack disabled
    @Test
    fun test7() = runTest {
        val params = EndpointParameters {
            region = "cn-north-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.cn-north-1.amazonaws.com.cn"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test8() = runTest {
        val params = EndpointParameters {
            region = "us-gov-east-1"
            useDualStack = true
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.us-gov-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test9() = runTest {
        val params = EndpointParameters {
            region = "us-gov-east-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.us-gov-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test10() = runTest {
        val params = EndpointParameters {
            region = "us-gov-east-1"
            useDualStack = true
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.us-gov-east-1.api.aws"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test11() = runTest {
        val params = EndpointParameters {
            region = "us-gov-east-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.us-gov-east-1.amazonaws.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-iso-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test12() = runTest {
        val params = EndpointParameters {
            region = "us-iso-east-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.us-iso-east-1.c2s.ic.gov"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-iso-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test13() = runTest {
        val params = EndpointParameters {
            region = "us-iso-east-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.us-iso-east-1.c2s.ic.gov"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-isob-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test14() = runTest {
        val params = EndpointParameters {
            region = "us-isob-east-1"
            useDualStack = false
            useFips = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler-fips.us-isob-east-1.sc2s.sgov.gov"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-isob-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test15() = runTest {
        val params = EndpointParameters {
            region = "us-isob-east-1"
            useDualStack = false
            useFips = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://codeguru-profiler.us-isob-east-1.sc2s.sgov.gov"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with region set and fips disabled and dualstack disabled
    @Test
    fun test16() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = false
            endpoint = "https://example.com"
        }
        val expected = Endpoint(
            uri = Url.parse("https://example.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with region not set and fips disabled and dualstack disabled
    @Test
    fun test17() = runTest {
        val params = EndpointParameters {
            useDualStack = false
            useFips = false
            endpoint = "https://example.com"
        }
        val expected = Endpoint(
            uri = Url.parse("https://example.com"),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips enabled and dualstack disabled
    @Test
    fun test18() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = false
            useFips = true
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: FIPS and custom endpoint are not supported", ex.message)
    }

    // For custom endpoint with fips disabled and dualstack enabled
    @Test
    fun test19() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useDualStack = true
            useFips = false
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: Dualstack and custom endpoint are not supported", ex.message)
    }

}
