// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A potential improvement that was found from analyzing the profiling data.
 */
public class Recommendation private constructor(builder: Builder) {
    /**
     * How many different places in the profile graph triggered a match.
     */
    public val allMatchesCount: kotlin.Int? = builder.allMatchesCount
    /**
     * How much of the total sample count is potentially affected.
     */
    public val allMatchesSum: kotlin.Double? = builder.allMatchesSum
    /**
     * End time of the profile that was used by this analysis. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The pattern that analysis recognized in the profile to make this recommendation.
     */
    public val pattern: aws.sdk.kotlin.services.codeguruprofiler.model.Pattern? = builder.pattern
    /**
     * The start time of the profile that was used by this analysis. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * List of the matches with most impact.
     */
    public val topMatches: List<Match>? = builder.topMatches

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.Recommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Recommendation(")
        append("allMatchesCount=$allMatchesCount,")
        append("allMatchesSum=$allMatchesSum,")
        append("endTime=$endTime,")
        append("pattern=$pattern,")
        append("startTime=$startTime,")
        append("topMatches=$topMatches")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allMatchesCount ?: 0
        result = 31 * result + (allMatchesSum?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (pattern?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (topMatches?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Recommendation

        if (allMatchesCount != other.allMatchesCount) return false
        if (allMatchesSum != other.allMatchesSum) return false
        if (endTime != other.endTime) return false
        if (pattern != other.pattern) return false
        if (startTime != other.startTime) return false
        if (topMatches != other.topMatches) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.Recommendation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * How many different places in the profile graph triggered a match.
         */
        public var allMatchesCount: kotlin.Int? = null
        /**
         * How much of the total sample count is potentially affected.
         */
        public var allMatchesSum: kotlin.Double? = null
        /**
         * End time of the profile that was used by this analysis. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The pattern that analysis recognized in the profile to make this recommendation.
         */
        public var pattern: aws.sdk.kotlin.services.codeguruprofiler.model.Pattern? = null
        /**
         * The start time of the profile that was used by this analysis. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * List of the matches with most impact.
         */
        public var topMatches: List<Match>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.Recommendation) : this() {
            this.allMatchesCount = x.allMatchesCount
            this.allMatchesSum = x.allMatchesSum
            this.endTime = x.endTime
            this.pattern = x.pattern
            this.startTime = x.startTime
            this.topMatches = x.topMatches
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.Recommendation = Recommendation(this)

        /**
         * construct an [aws.sdk.kotlin.services.codeguruprofiler.model.Pattern] inside the given [block]
         */
        public fun pattern(block: aws.sdk.kotlin.services.codeguruprofiler.model.Pattern.Builder.() -> kotlin.Unit) {
            this.pattern = aws.sdk.kotlin.services.codeguruprofiler.model.Pattern.invoke(block)
        }
    }
}
