// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The structure representing the listProfileTimesRequest.
 */
public class ListProfileTimesRequest private constructor(builder: Builder) {
    /**
     * The end time of the time range from which to list the profiles.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = requireNotNull(builder.endTime) { "A non-null value must be provided for endTime" }
    /**
     * The maximum number of profile time results returned by `ListProfileTimes` in paginated output. When this parameter is used, `ListProfileTimes` only returns `maxResults` results in a single page with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `ListProfileTimes` request with the returned `nextToken` value.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The `nextToken` value returned from a previous paginated `ListProfileTimes` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value.
     *
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The order (ascending or descending by start time of the profile) to use when listing profiles. Defaults to `TIMESTAMP_DESCENDING`.
     */
    public val orderBy: aws.sdk.kotlin.services.codeguruprofiler.model.OrderBy? = builder.orderBy
    /**
     * The aggregation period. This specifies the period during which an aggregation profile collects posted agent profiles for a profiling group. There are 3 valid values.
     * + `P1D` — 1 day
     * + `PT1H` — 1 hour
     * + `PT5M` — 5 minutes
     */
    public val period: aws.sdk.kotlin.services.codeguruprofiler.model.AggregationPeriod? = requireNotNull(builder.period) { "A non-null value must be provided for period" }
    /**
     * The name of the profiling group.
     */
    public val profilingGroupName: kotlin.String? = requireNotNull(builder.profilingGroupName) { "A non-null value must be provided for profilingGroupName" }
    /**
     * The start time of the time range from which to list the profiles.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.ListProfileTimesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListProfileTimesRequest(")
        append("endTime=$endTime,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("orderBy=$orderBy,")
        append("period=$period,")
        append("profilingGroupName=$profilingGroupName,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (orderBy?.hashCode() ?: 0)
        result = 31 * result + (period?.hashCode() ?: 0)
        result = 31 * result + (profilingGroupName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListProfileTimesRequest

        if (endTime != other.endTime) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (orderBy != other.orderBy) return false
        if (period != other.period) return false
        if (profilingGroupName != other.profilingGroupName) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.ListProfileTimesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The end time of the time range from which to list the profiles.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The maximum number of profile time results returned by `ListProfileTimes` in paginated output. When this parameter is used, `ListProfileTimes` only returns `maxResults` results in a single page with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `ListProfileTimes` request with the returned `nextToken` value.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The `nextToken` value returned from a previous paginated `ListProfileTimes` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value.
         *
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The order (ascending or descending by start time of the profile) to use when listing profiles. Defaults to `TIMESTAMP_DESCENDING`.
         */
        public var orderBy: aws.sdk.kotlin.services.codeguruprofiler.model.OrderBy? = null
        /**
         * The aggregation period. This specifies the period during which an aggregation profile collects posted agent profiles for a profiling group. There are 3 valid values.
         * + `P1D` — 1 day
         * + `PT1H` — 1 hour
         * + `PT5M` — 5 minutes
         */
        public var period: aws.sdk.kotlin.services.codeguruprofiler.model.AggregationPeriod? = null
        /**
         * The name of the profiling group.
         */
        public var profilingGroupName: kotlin.String? = null
        /**
         * The start time of the time range from which to list the profiles.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.ListProfileTimesRequest) : this() {
            this.endTime = x.endTime
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.orderBy = x.orderBy
            this.period = x.period
            this.profilingGroupName = x.profilingGroupName
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.ListProfileTimesRequest = ListProfileTimesRequest(this)
    }
}
