// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model



/**
 * The structure representing the createProfiliingGroupRequest.
 */
public class CreateProfilingGroupRequest private constructor(builder: Builder) {
    /**
     * Specifies whether profiling is enabled or disabled for the created profiling group.
     */
    public val agentOrchestrationConfig: aws.sdk.kotlin.services.codeguruprofiler.model.AgentOrchestrationConfig? = builder.agentOrchestrationConfig
    /**
     * Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental creation of duplicate profiling groups if there are failures and retries.
     */
    public val clientToken: kotlin.String? = requireNotNull(builder.clientToken) { "A non-null value must be provided for clientToken" }
    /**
     * The compute platform of the profiling group. Use `AWSLambda` if your application runs on AWS Lambda. Use `Default` if your application runs on a compute platform that is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different platform. If not specified, `Default` is used.
     */
    public val computePlatform: aws.sdk.kotlin.services.codeguruprofiler.model.ComputePlatform? = builder.computePlatform
    /**
     * The name of the profiling group to create.
     */
    public val profilingGroupName: kotlin.String? = builder.profilingGroupName
    /**
     * A list of tags to add to the created profiling group.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.CreateProfilingGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateProfilingGroupRequest(")
        append("agentOrchestrationConfig=$agentOrchestrationConfig,")
        append("clientToken=$clientToken,")
        append("computePlatform=$computePlatform,")
        append("profilingGroupName=$profilingGroupName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentOrchestrationConfig?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (computePlatform?.hashCode() ?: 0)
        result = 31 * result + (profilingGroupName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateProfilingGroupRequest

        if (agentOrchestrationConfig != other.agentOrchestrationConfig) return false
        if (clientToken != other.clientToken) return false
        if (computePlatform != other.computePlatform) return false
        if (profilingGroupName != other.profilingGroupName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.CreateProfilingGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether profiling is enabled or disabled for the created profiling group.
         */
        public var agentOrchestrationConfig: aws.sdk.kotlin.services.codeguruprofiler.model.AgentOrchestrationConfig? = null
        /**
         * Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental creation of duplicate profiling groups if there are failures and retries.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The compute platform of the profiling group. Use `AWSLambda` if your application runs on AWS Lambda. Use `Default` if your application runs on a compute platform that is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different platform. If not specified, `Default` is used.
         */
        public var computePlatform: aws.sdk.kotlin.services.codeguruprofiler.model.ComputePlatform? = null
        /**
         * The name of the profiling group to create.
         */
        public var profilingGroupName: kotlin.String? = null
        /**
         * A list of tags to add to the created profiling group.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.CreateProfilingGroupRequest) : this() {
            this.agentOrchestrationConfig = x.agentOrchestrationConfig
            this.clientToken = x.clientToken
            this.computePlatform = x.computePlatform
            this.profilingGroupName = x.profilingGroupName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.CreateProfilingGroupRequest = CreateProfilingGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codeguruprofiler.model.AgentOrchestrationConfig] inside the given [block]
         */
        public fun agentOrchestrationConfig(block: aws.sdk.kotlin.services.codeguruprofiler.model.AgentOrchestrationConfig.Builder.() -> kotlin.Unit) {
            this.agentOrchestrationConfig = aws.sdk.kotlin.services.codeguruprofiler.model.AgentOrchestrationConfig.invoke(block)
        }
    }
}
