// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.transform

import aws.sdk.kotlin.services.codeguruprofiler.model.CodeGuruProfilerException
import aws.sdk.kotlin.services.codeguruprofiler.model.DescribeProfilingGroupResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.ProfilingGroupDescription
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DescribeProfilingGroupOperationDeserializer: HttpDeserialize<DescribeProfilingGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeProfilingGroupResponse {
        if (!response.status.isSuccess()) {
            throwDescribeProfilingGroupError(context, response)
        }
        val builder = DescribeProfilingGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            builder.profilingGroup = deserializeProfilingGroupDescriptionPayload(payload)
        }

        return builder.build()
    }
}

private suspend fun throwDescribeProfilingGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeGuruProfilerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeGuruProfilerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
