// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.transform

import aws.sdk.kotlin.services.codeguruprofiler.model.AggregationPeriod
import aws.sdk.kotlin.services.codeguruprofiler.model.BatchGetFrameMetricDataResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.CodeGuruProfilerException
import aws.sdk.kotlin.services.codeguruprofiler.model.FrameMetricDatum
import aws.sdk.kotlin.services.codeguruprofiler.model.TimestampStructure
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class BatchGetFrameMetricDataOperationDeserializer: HttpDeserialize<BatchGetFrameMetricDataResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchGetFrameMetricDataResponse {
        if (!response.status.isSuccess()) {
            throwBatchGetFrameMetricDataError(context, response)
        }
        val builder = BatchGetFrameMetricDataResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchGetFrameMetricDataOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchGetFrameMetricDataError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeGuruProfilerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeGuruProfilerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetFrameMetricDataOperationBody(builder: BatchGetFrameMetricDataResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endTime"))
    val ENDTIMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("endTimes"))
    val FRAMEMETRICDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("frameMetricData"))
    val RESOLUTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("resolution"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startTime"))
    val UNPROCESSEDENDTIMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("unprocessedEndTimes"))
    val UNPROCESSEDENDTIMES_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDTIME_DESCRIPTOR)
        field(ENDTIMES_DESCRIPTOR)
        field(FRAMEMETRICDATA_DESCRIPTOR)
        field(RESOLUTION_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(UNPROCESSEDENDTIMES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeString().let { Instant.fromIso8601(it) }
                ENDTIMES_DESCRIPTOR.index -> builder.endTimes =
                    deserializer.deserializeList(ENDTIMES_DESCRIPTOR) {
                        val col0 = mutableListOf<TimestampStructure>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTimestampStructureDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FRAMEMETRICDATA_DESCRIPTOR.index -> builder.frameMetricData =
                    deserializer.deserializeList(FRAMEMETRICDATA_DESCRIPTOR) {
                        val col0 = mutableListOf<FrameMetricDatum>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFrameMetricDatumDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RESOLUTION_DESCRIPTOR.index -> builder.resolution = deserializeString().let { AggregationPeriod.fromValue(it) }
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromIso8601(it) }
                UNPROCESSEDENDTIMES_DESCRIPTOR.index -> builder.unprocessedEndTimes =
                    deserializer.deserializeMap(UNPROCESSEDENDTIMES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, List<TimestampStructure>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeList(UNPROCESSEDENDTIMES_C0_DESCRIPTOR) {
                                        val col1 = mutableListOf<TimestampStructure>()
                                        while (hasNextElement()) {
                                            val el1 = if (nextHasValue()) { deserializeTimestampStructureDocument(deserializer) } else { deserializeNull(); continue }
                                            col1.add(el1)
                                        }
                                        col1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
