// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a profiling group.
 */
public class ProfilingGroupDescription private constructor(builder: Builder) {
    /**
     * An `AgentOrchestrationConfig`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentOrchestrationConfig.html) object that indicates if the profiling group is enabled for profiled or not.
     */
    public val agentOrchestrationConfig: aws.sdk.kotlin.services.codeguruprofiler.model.AgentOrchestrationConfig? = builder.agentOrchestrationConfig
    /**
     * The Amazon Resource Name (ARN) identifying the profiling group resource.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The compute platform of the profiling group. If it is set to `AWSLambda`, then the profiled application runs on AWS Lambda. If it is set to `Default`, then the profiled application runs on a compute platform that is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different platform. The default is `Default`.
     */
    public val computePlatform: aws.sdk.kotlin.services.codeguruprofiler.model.ComputePlatform? = builder.computePlatform
    /**
     * The time when the profiling group was created. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The name of the profiling group.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A `ProfilingStatus`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingStatus.html) object that includes information about the last time a profile agent pinged back, the last time a profile was received, and the aggregation period and start time for the most recent aggregated profile.
     */
    public val profilingStatus: aws.sdk.kotlin.services.codeguruprofiler.model.ProfilingStatus? = builder.profilingStatus
    /**
     * A list of the tags that belong to this profiling group.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The date and time when the profiling group was last updated. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.ProfilingGroupDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProfilingGroupDescription(")
        append("agentOrchestrationConfig=$agentOrchestrationConfig,")
        append("arn=$arn,")
        append("computePlatform=$computePlatform,")
        append("createdAt=$createdAt,")
        append("name=$name,")
        append("profilingStatus=$profilingStatus,")
        append("tags=$tags,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentOrchestrationConfig?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (computePlatform?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (profilingStatus?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProfilingGroupDescription

        if (agentOrchestrationConfig != other.agentOrchestrationConfig) return false
        if (arn != other.arn) return false
        if (computePlatform != other.computePlatform) return false
        if (createdAt != other.createdAt) return false
        if (name != other.name) return false
        if (profilingStatus != other.profilingStatus) return false
        if (tags != other.tags) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.ProfilingGroupDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An `AgentOrchestrationConfig`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentOrchestrationConfig.html) object that indicates if the profiling group is enabled for profiled or not.
         */
        public var agentOrchestrationConfig: aws.sdk.kotlin.services.codeguruprofiler.model.AgentOrchestrationConfig? = null
        /**
         * The Amazon Resource Name (ARN) identifying the profiling group resource.
         */
        public var arn: kotlin.String? = null
        /**
         * The compute platform of the profiling group. If it is set to `AWSLambda`, then the profiled application runs on AWS Lambda. If it is set to `Default`, then the profiled application runs on a compute platform that is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different platform. The default is `Default`.
         */
        public var computePlatform: aws.sdk.kotlin.services.codeguruprofiler.model.ComputePlatform? = null
        /**
         * The time when the profiling group was created. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the profiling group.
         */
        public var name: kotlin.String? = null
        /**
         * A `ProfilingStatus`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingStatus.html) object that includes information about the last time a profile agent pinged back, the last time a profile was received, and the aggregation period and start time for the most recent aggregated profile.
         */
        public var profilingStatus: aws.sdk.kotlin.services.codeguruprofiler.model.ProfilingStatus? = null
        /**
         * A list of the tags that belong to this profiling group.
         */
        public var tags: Map<String, String>? = null
        /**
         * The date and time when the profiling group was last updated. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.ProfilingGroupDescription) : this() {
            this.agentOrchestrationConfig = x.agentOrchestrationConfig
            this.arn = x.arn
            this.computePlatform = x.computePlatform
            this.createdAt = x.createdAt
            this.name = x.name
            this.profilingStatus = x.profilingStatus
            this.tags = x.tags
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.ProfilingGroupDescription = ProfilingGroupDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.codeguruprofiler.model.AgentOrchestrationConfig] inside the given [block]
         */
        public fun agentOrchestrationConfig(block: aws.sdk.kotlin.services.codeguruprofiler.model.AgentOrchestrationConfig.Builder.() -> kotlin.Unit) {
            this.agentOrchestrationConfig = aws.sdk.kotlin.services.codeguruprofiler.model.AgentOrchestrationConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codeguruprofiler.model.ProfilingStatus] inside the given [block]
         */
        public fun profilingStatus(block: aws.sdk.kotlin.services.codeguruprofiler.model.ProfilingStatus.Builder.() -> kotlin.Unit) {
            this.profilingStatus = aws.sdk.kotlin.services.codeguruprofiler.model.ProfilingStatus.invoke(block)
        }
    }
}
