// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.codeguruprofiler.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.codeguruprofiler.endpoints.EndpointProvider
import aws.sdk.kotlin.services.codeguruprofiler.model.AddNotificationChannelsRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.AddNotificationChannelsResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.BatchGetFrameMetricDataRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.BatchGetFrameMetricDataResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.ConfigureAgentRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.ConfigureAgentResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.CreateProfilingGroupRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.CreateProfilingGroupResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.DeleteProfilingGroupRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.DeleteProfilingGroupResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.DescribeProfilingGroupRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.DescribeProfilingGroupResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.GetNotificationConfigurationRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.GetNotificationConfigurationResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.GetPolicyRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.GetPolicyResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.GetProfileRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.GetProfileResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.GetRecommendationsRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.GetRecommendationsResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.ListFindingsReportsRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.ListFindingsReportsResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.ListProfileTimesRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.ListProfileTimesResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.ListProfilingGroupsRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.ListProfilingGroupsResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.PostAgentProfileRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.PostAgentProfileResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.PutPermissionRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.PutPermissionResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.RemoveNotificationChannelRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.RemoveNotificationChannelResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.RemovePermissionRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.RemovePermissionResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.SubmitFeedbackRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.SubmitFeedbackResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.TagResourceRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.TagResourceResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.UntagResourceRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.UntagResourceResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.UpdateProfilingGroupRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.UpdateProfilingGroupResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.internal.manage
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * This section provides documentation for the Amazon CodeGuru Profiler API operations.
 *
 *  Amazon CodeGuru Profiler collects runtime performance data from your live applications, and provides recommendations that can help you fine-tune your application performance. Using machine learning algorithms, CodeGuru Profiler can help you find your most expensive lines of code and suggest ways you can improve efficiency and remove CPU bottlenecks.
 *
 *  Amazon CodeGuru Profiler provides different visualizations of profiling data to help you identify what code is running on the CPU, see how much time is consumed, and suggest ways to reduce CPU utilization.
 *
 * Amazon CodeGuru Profiler currently supports applications written in all Java virtual machine (JVM) languages and Python. While CodeGuru Profiler supports both visualizations and recommendations for applications written in Java, it can also generate visualizations and a subset of recommendations for applications written in other JVM languages and Python.
 *
 *  For more information, see [What is Amazon CodeGuru Profiler](https://docs.aws.amazon.com/codeguru/latest/profiler-ug/what-is-codeguru-profiler.html) in the *Amazon CodeGuru Profiler User Guide*.
 */
public interface CodeGuruProfilerClient : SdkClient {

    override val serviceName: String
        get() = "CodeGuruProfiler"
    /**
     * CodeGuruProfilerClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CodeGuruProfilerClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CodeGuruProfilerClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CodeGuruProfilerClient = DefaultCodeGuruProfilerClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine = builder.httpClientEngine ?: DefaultHttpEngine().manage()
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "CodeGuruProfiler")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            httpClientEngine = this@Config.httpClientEngine
            region = this@Config.region
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            sdkLogMode = this@Config.sdkLogMode
            signer = this@Config.signer
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, HttpClientConfig.Builder, IdempotencyTokenConfig.Builder, SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            override var httpClientEngine: HttpClientEngine? = null

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            override var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false

            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Add up to 2 anomaly notifications channels for a profiling group.
     */
    public suspend fun addNotificationChannels(input: AddNotificationChannelsRequest): AddNotificationChannelsResponse

    /**
     * Returns the time series of values for a requested list of frame metrics from a time period.
     */
    public suspend fun batchGetFrameMetricData(input: BatchGetFrameMetricDataRequest): BatchGetFrameMetricDataResponse

    /**
     * Used by profiler agents to report their current state and to receive remote configuration updates. For example, `ConfigureAgent` can be used to tell an agent whether to profile or not and for how long to return profiling data.
     */
    public suspend fun configureAgent(input: ConfigureAgentRequest): ConfigureAgentResponse

    /**
     * Creates a profiling group.
     */
    public suspend fun createProfilingGroup(input: CreateProfilingGroupRequest): CreateProfilingGroupResponse

    /**
     * Deletes a profiling group.
     */
    public suspend fun deleteProfilingGroup(input: DeleteProfilingGroupRequest): DeleteProfilingGroupResponse

    /**
     * Returns a `ProfilingGroupDescription`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html) object that contains information about the requested profiling group.
     */
    public suspend fun describeProfilingGroup(input: DescribeProfilingGroupRequest): DescribeProfilingGroupResponse

    /**
     * Returns a list of `FindingsReportSummary`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html) objects that contain analysis results for all profiling groups in your AWS account.
     */
    public suspend fun getFindingsReportAccountSummary(input: GetFindingsReportAccountSummaryRequest = GetFindingsReportAccountSummaryRequest {}): GetFindingsReportAccountSummaryResponse

    /**
     * Get the current configuration for anomaly notifications for a profiling group.
     */
    public suspend fun getNotificationConfiguration(input: GetNotificationConfigurationRequest): GetNotificationConfigurationResponse

    /**
     * Returns the JSON-formatted resource-based policy on a profiling group.
     */
    public suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse

    /**
     * Gets the aggregated profile of a profiling group for a specified time range. Amazon CodeGuru Profiler collects posted agent profiles for a profiling group into aggregated profiles.
     *
     *  Because aggregated profiles expire over time `GetProfile` is not idempotent.
     *
     *  Specify the time range for the requested aggregated profile using 1 or 2 of the following parameters: `startTime`, `endTime`, `period`. The maximum time range allowed is 7 days. If you specify all 3 parameters, an exception is thrown. If you specify only `period`, the latest aggregated profile is returned.
     *
     *  Aggregated profiles are available with aggregation periods of 5 minutes, 1 hour, and 1 day, aligned to UTC. The aggregation period of an aggregated profile determines how long it is retained. For more information, see `AggregatedProfileTime`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html). The aggregated profile's aggregation period determines how long it is retained by CodeGuru Profiler.
     * +  If the aggregation period is 5 minutes, the aggregated profile is retained for 15 days.
     * +  If the aggregation period is 1 hour, the aggregated profile is retained for 60 days.
     * +  If the aggregation period is 1 day, the aggregated profile is retained for 3 years.
     *
     * There are two use cases for calling `GetProfile`.
     * +  If you want to return an aggregated profile that already exists, use `ListProfileTimes`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ListProfileTimes.html) to view the time ranges of existing aggregated profiles. Use them in a `GetProfile` request to return a specific, existing aggregated profile.
     * +  If you want to return an aggregated profile for a time range that doesn't align with an existing aggregated profile, then CodeGuru Profiler makes a best effort to combine existing aggregated profiles from the requested time range and return them as one aggregated profile.  If aggregated profiles do not exist for the full time range requested, then aggregated profiles for a smaller time range are returned. For example, if the requested time range is from 00:00 to 00:20, and the existing aggregated profiles are from 00:15 and 00:25, then the aggregated profiles from 00:15 to 00:20 are returned.
     */
    public suspend fun getProfile(input: GetProfileRequest): GetProfileResponse

    /**
     * Returns a list of `Recommendation`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Recommendation.html) objects that contain recommendations for a profiling group for a given time period. A list of `Anomaly`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Anomaly.html) objects that contains details about anomalies detected in the profiling group for the same time period is also returned.
     */
    public suspend fun getRecommendations(input: GetRecommendationsRequest): GetRecommendationsResponse

    /**
     * List the available reports for a given profiling group and time range.
     */
    public suspend fun listFindingsReports(input: ListFindingsReportsRequest): ListFindingsReportsResponse

    /**
     * Lists the start times of the available aggregated profiles of a profiling group for an aggregation period within the specified time range.
     */
    public suspend fun listProfileTimes(input: ListProfileTimesRequest): ListProfileTimesResponse

    /**
     * Returns a list of profiling groups. The profiling groups are returned as `ProfilingGroupDescription`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html) objects.
     */
    public suspend fun listProfilingGroups(input: ListProfilingGroupsRequest = ListProfilingGroupsRequest {}): ListProfilingGroupsResponse

    /**
     * Returns a list of the tags that are assigned to a specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Submits profiling data to an aggregated profile of a profiling group. To get an aggregated profile that is created with this profiling data, use `GetProfile`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetProfile.html).
     */
    public suspend fun postAgentProfile(input: PostAgentProfileRequest): PostAgentProfileResponse

    /**
     * Adds permissions to a profiling group's resource-based policy that are provided using an action group. If a profiling group doesn't have a resource-based policy, one is created for it using the permissions in the action group and the roles and users in the `principals` parameter.
     *
     *  The one supported action group that can be added is `agentPermission` which grants `ConfigureAgent` and `PostAgent` permissions. For more information, see [Resource-based policies in CodeGuru Profiler](https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html) in the *Amazon CodeGuru Profiler User Guide*, `ConfigureAgent`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html), and `PostAgentProfile`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html).
     *
     *  The first time you call `PutPermission` on a profiling group, do not specify a `revisionId` because it doesn't have a resource-based policy. Subsequent calls must provide a `revisionId` to specify which revision of the resource-based policy to add the permissions to.
     *
     *  The response contains the profiling group's JSON-formatted resource policy.
     */
    public suspend fun putPermission(input: PutPermissionRequest): PutPermissionResponse

    /**
     * Remove one anomaly notifications channel for a profiling group.
     */
    public suspend fun removeNotificationChannel(input: RemoveNotificationChannelRequest): RemoveNotificationChannelResponse

    /**
     * Removes permissions from a profiling group's resource-based policy that are provided using an action group. The one supported action group that can be removed is `agentPermission` which grants `ConfigureAgent` and `PostAgent` permissions. For more information, see [Resource-based policies in CodeGuru Profiler](https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html) in the *Amazon CodeGuru Profiler User Guide*, `ConfigureAgent`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html), and `PostAgentProfile`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html).
     */
    public suspend fun removePermission(input: RemovePermissionRequest): RemovePermissionResponse

    /**
     * Sends feedback to CodeGuru Profiler about whether the anomaly detected by the analysis is useful or not.
     */
    public suspend fun submitFeedback(input: SubmitFeedbackRequest): SubmitFeedbackResponse

    /**
     * Use to assign one or more tags to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Use to remove one or more tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a profiling group.
     */
    public suspend fun updateProfilingGroup(input: UpdateProfilingGroupRequest): UpdateProfilingGroupResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CodeGuruProfilerClient.withConfig(block: CodeGuruProfilerClient.Config.Builder.() -> Unit): CodeGuruProfilerClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCodeGuruProfilerClient(newConfig)
}

/**
 * Add up to 2 anomaly notifications channels for a profiling group.
 */
public suspend inline fun CodeGuruProfilerClient.addNotificationChannels(crossinline block: AddNotificationChannelsRequest.Builder.() -> Unit): AddNotificationChannelsResponse = addNotificationChannels(AddNotificationChannelsRequest.Builder().apply(block).build())

/**
 * Returns the time series of values for a requested list of frame metrics from a time period.
 */
public suspend inline fun CodeGuruProfilerClient.batchGetFrameMetricData(crossinline block: BatchGetFrameMetricDataRequest.Builder.() -> Unit): BatchGetFrameMetricDataResponse = batchGetFrameMetricData(BatchGetFrameMetricDataRequest.Builder().apply(block).build())

/**
 * Used by profiler agents to report their current state and to receive remote configuration updates. For example, `ConfigureAgent` can be used to tell an agent whether to profile or not and for how long to return profiling data.
 */
public suspend inline fun CodeGuruProfilerClient.configureAgent(crossinline block: ConfigureAgentRequest.Builder.() -> Unit): ConfigureAgentResponse = configureAgent(ConfigureAgentRequest.Builder().apply(block).build())

/**
 * Creates a profiling group.
 */
public suspend inline fun CodeGuruProfilerClient.createProfilingGroup(crossinline block: CreateProfilingGroupRequest.Builder.() -> Unit): CreateProfilingGroupResponse = createProfilingGroup(CreateProfilingGroupRequest.Builder().apply(block).build())

/**
 * Deletes a profiling group.
 */
public suspend inline fun CodeGuruProfilerClient.deleteProfilingGroup(crossinline block: DeleteProfilingGroupRequest.Builder.() -> Unit): DeleteProfilingGroupResponse = deleteProfilingGroup(DeleteProfilingGroupRequest.Builder().apply(block).build())

/**
 * Returns a `ProfilingGroupDescription`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html) object that contains information about the requested profiling group.
 */
public suspend inline fun CodeGuruProfilerClient.describeProfilingGroup(crossinline block: DescribeProfilingGroupRequest.Builder.() -> Unit): DescribeProfilingGroupResponse = describeProfilingGroup(DescribeProfilingGroupRequest.Builder().apply(block).build())

/**
 * Returns a list of `FindingsReportSummary`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html) objects that contain analysis results for all profiling groups in your AWS account.
 */
public suspend inline fun CodeGuruProfilerClient.getFindingsReportAccountSummary(crossinline block: GetFindingsReportAccountSummaryRequest.Builder.() -> Unit): GetFindingsReportAccountSummaryResponse = getFindingsReportAccountSummary(GetFindingsReportAccountSummaryRequest.Builder().apply(block).build())

/**
 * Get the current configuration for anomaly notifications for a profiling group.
 */
public suspend inline fun CodeGuruProfilerClient.getNotificationConfiguration(crossinline block: GetNotificationConfigurationRequest.Builder.() -> Unit): GetNotificationConfigurationResponse = getNotificationConfiguration(GetNotificationConfigurationRequest.Builder().apply(block).build())

/**
 * Returns the JSON-formatted resource-based policy on a profiling group.
 */
public suspend inline fun CodeGuruProfilerClient.getPolicy(crossinline block: GetPolicyRequest.Builder.() -> Unit): GetPolicyResponse = getPolicy(GetPolicyRequest.Builder().apply(block).build())

/**
 * Gets the aggregated profile of a profiling group for a specified time range. Amazon CodeGuru Profiler collects posted agent profiles for a profiling group into aggregated profiles.
 *
 *  Because aggregated profiles expire over time `GetProfile` is not idempotent.
 *
 *  Specify the time range for the requested aggregated profile using 1 or 2 of the following parameters: `startTime`, `endTime`, `period`. The maximum time range allowed is 7 days. If you specify all 3 parameters, an exception is thrown. If you specify only `period`, the latest aggregated profile is returned.
 *
 *  Aggregated profiles are available with aggregation periods of 5 minutes, 1 hour, and 1 day, aligned to UTC. The aggregation period of an aggregated profile determines how long it is retained. For more information, see `AggregatedProfileTime`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html). The aggregated profile's aggregation period determines how long it is retained by CodeGuru Profiler.
 * +  If the aggregation period is 5 minutes, the aggregated profile is retained for 15 days.
 * +  If the aggregation period is 1 hour, the aggregated profile is retained for 60 days.
 * +  If the aggregation period is 1 day, the aggregated profile is retained for 3 years.
 *
 * There are two use cases for calling `GetProfile`.
 * +  If you want to return an aggregated profile that already exists, use `ListProfileTimes`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ListProfileTimes.html) to view the time ranges of existing aggregated profiles. Use them in a `GetProfile` request to return a specific, existing aggregated profile.
 * +  If you want to return an aggregated profile for a time range that doesn't align with an existing aggregated profile, then CodeGuru Profiler makes a best effort to combine existing aggregated profiles from the requested time range and return them as one aggregated profile.  If aggregated profiles do not exist for the full time range requested, then aggregated profiles for a smaller time range are returned. For example, if the requested time range is from 00:00 to 00:20, and the existing aggregated profiles are from 00:15 and 00:25, then the aggregated profiles from 00:15 to 00:20 are returned.
 */
public suspend inline fun CodeGuruProfilerClient.getProfile(crossinline block: GetProfileRequest.Builder.() -> Unit): GetProfileResponse = getProfile(GetProfileRequest.Builder().apply(block).build())

/**
 * Returns a list of `Recommendation`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Recommendation.html) objects that contain recommendations for a profiling group for a given time period. A list of `Anomaly`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Anomaly.html) objects that contains details about anomalies detected in the profiling group for the same time period is also returned.
 */
public suspend inline fun CodeGuruProfilerClient.getRecommendations(crossinline block: GetRecommendationsRequest.Builder.() -> Unit): GetRecommendationsResponse = getRecommendations(GetRecommendationsRequest.Builder().apply(block).build())

/**
 * List the available reports for a given profiling group and time range.
 */
public suspend inline fun CodeGuruProfilerClient.listFindingsReports(crossinline block: ListFindingsReportsRequest.Builder.() -> Unit): ListFindingsReportsResponse = listFindingsReports(ListFindingsReportsRequest.Builder().apply(block).build())

/**
 * Lists the start times of the available aggregated profiles of a profiling group for an aggregation period within the specified time range.
 */
public suspend inline fun CodeGuruProfilerClient.listProfileTimes(crossinline block: ListProfileTimesRequest.Builder.() -> Unit): ListProfileTimesResponse = listProfileTimes(ListProfileTimesRequest.Builder().apply(block).build())

/**
 * Returns a list of profiling groups. The profiling groups are returned as `ProfilingGroupDescription`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html) objects.
 */
public suspend inline fun CodeGuruProfilerClient.listProfilingGroups(crossinline block: ListProfilingGroupsRequest.Builder.() -> Unit): ListProfilingGroupsResponse = listProfilingGroups(ListProfilingGroupsRequest.Builder().apply(block).build())

/**
 * Returns a list of the tags that are assigned to a specified resource.
 */
public suspend inline fun CodeGuruProfilerClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Submits profiling data to an aggregated profile of a profiling group. To get an aggregated profile that is created with this profiling data, use `GetProfile`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetProfile.html).
 */
public suspend inline fun CodeGuruProfilerClient.postAgentProfile(crossinline block: PostAgentProfileRequest.Builder.() -> Unit): PostAgentProfileResponse = postAgentProfile(PostAgentProfileRequest.Builder().apply(block).build())

/**
 * Adds permissions to a profiling group's resource-based policy that are provided using an action group. If a profiling group doesn't have a resource-based policy, one is created for it using the permissions in the action group and the roles and users in the `principals` parameter.
 *
 *  The one supported action group that can be added is `agentPermission` which grants `ConfigureAgent` and `PostAgent` permissions. For more information, see [Resource-based policies in CodeGuru Profiler](https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html) in the *Amazon CodeGuru Profiler User Guide*, `ConfigureAgent`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html), and `PostAgentProfile`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html).
 *
 *  The first time you call `PutPermission` on a profiling group, do not specify a `revisionId` because it doesn't have a resource-based policy. Subsequent calls must provide a `revisionId` to specify which revision of the resource-based policy to add the permissions to.
 *
 *  The response contains the profiling group's JSON-formatted resource policy.
 */
public suspend inline fun CodeGuruProfilerClient.putPermission(crossinline block: PutPermissionRequest.Builder.() -> Unit): PutPermissionResponse = putPermission(PutPermissionRequest.Builder().apply(block).build())

/**
 * Remove one anomaly notifications channel for a profiling group.
 */
public suspend inline fun CodeGuruProfilerClient.removeNotificationChannel(crossinline block: RemoveNotificationChannelRequest.Builder.() -> Unit): RemoveNotificationChannelResponse = removeNotificationChannel(RemoveNotificationChannelRequest.Builder().apply(block).build())

/**
 * Removes permissions from a profiling group's resource-based policy that are provided using an action group. The one supported action group that can be removed is `agentPermission` which grants `ConfigureAgent` and `PostAgent` permissions. For more information, see [Resource-based policies in CodeGuru Profiler](https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html) in the *Amazon CodeGuru Profiler User Guide*, `ConfigureAgent`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html), and `PostAgentProfile`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html).
 */
public suspend inline fun CodeGuruProfilerClient.removePermission(crossinline block: RemovePermissionRequest.Builder.() -> Unit): RemovePermissionResponse = removePermission(RemovePermissionRequest.Builder().apply(block).build())

/**
 * Sends feedback to CodeGuru Profiler about whether the anomaly detected by the analysis is useful or not.
 */
public suspend inline fun CodeGuruProfilerClient.submitFeedback(crossinline block: SubmitFeedbackRequest.Builder.() -> Unit): SubmitFeedbackResponse = submitFeedback(SubmitFeedbackRequest.Builder().apply(block).build())

/**
 * Use to assign one or more tags to a resource.
 */
public suspend inline fun CodeGuruProfilerClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Use to remove one or more tags from a resource.
 */
public suspend inline fun CodeGuruProfilerClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a profiling group.
 */
public suspend inline fun CodeGuruProfilerClient.updateProfilingGroup(crossinline block: UpdateProfilingGroupRequest.Builder.() -> Unit): UpdateProfilingGroupResponse = updateProfilingGroup(UpdateProfilingGroupRequest.Builder().apply(block).build())
