// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.serde

import aws.sdk.kotlin.services.codeguruprofiler.model.PostAgentProfileRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class PostAgentProfileOperationSerializer: HttpSerializer.NonStreaming<PostAgentProfileRequest> {
    override fun serialize(context: ExecutionContext, input: PostAgentProfileRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("profilingGroups"))
                add(PercentEncoding.SmithyLabel.encode(input.profilingGroupName))
                add(PercentEncoding.Path.encode("agentProfile"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                add("profileToken", (input.profileToken ?: context.idempotencyTokenProvider.generateToken()))
            }
        }

        builder.headers {
            append("Content-Type", input.contentType)
        }

        if (input.agentProfile != null) {
            builder.body = HttpBody.fromBytes(input.agentProfile)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.agentProfile == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
