// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.serde

import aws.sdk.kotlin.services.codeguruprofiler.model.Anomaly
import aws.sdk.kotlin.services.codeguruprofiler.model.CodeGuruProfilerException
import aws.sdk.kotlin.services.codeguruprofiler.model.GetRecommendationsResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.Recommendation
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class GetRecommendationsOperationDeserializer: HttpDeserializer.NonStreaming<GetRecommendationsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetRecommendationsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetRecommendationsError(context, call, payload)
        }
        val builder = GetRecommendationsResponse.Builder()

        if (payload != null) {
            deserializeGetRecommendationsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetRecommendationsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeGuruProfilerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeGuruProfilerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRecommendationsOperationBody(builder: GetRecommendationsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ANOMALIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("anomalies"))
    val PROFILEENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("profileEndTime"))
    val PROFILESTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("profileStartTime"))
    val PROFILINGGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("profilingGroupName"))
    val RECOMMENDATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("recommendations"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ANOMALIES_DESCRIPTOR)
        field(PROFILEENDTIME_DESCRIPTOR)
        field(PROFILESTARTTIME_DESCRIPTOR)
        field(PROFILINGGROUPNAME_DESCRIPTOR)
        field(RECOMMENDATIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ANOMALIES_DESCRIPTOR.index -> builder.anomalies =
                    deserializer.deserializeList(ANOMALIES_DESCRIPTOR) {
                        val col0 = mutableListOf<Anomaly>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAnomalyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROFILEENDTIME_DESCRIPTOR.index -> builder.profileEndTime = deserializeInstant(TimestampFormat.ISO_8601)
                PROFILESTARTTIME_DESCRIPTOR.index -> builder.profileStartTime = deserializeInstant(TimestampFormat.ISO_8601)
                PROFILINGGROUPNAME_DESCRIPTOR.index -> builder.profilingGroupName = deserializeString()
                RECOMMENDATIONS_DESCRIPTOR.index -> builder.recommendations =
                    deserializer.deserializeList(RECOMMENDATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<Recommendation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRecommendationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
