// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The structure representing the `putPermissionRequest`.
 */
public class PutPermissionRequest private constructor(builder: Builder) {
    /**
     * Specifies an action group that contains permissions to add to a profiling group resource. One action group is supported, `agentPermissions`, which grants permission to perform actions required by the profiling agent, `ConfigureAgent` and `PostAgentProfile` permissions.
     */
    public val actionGroup: aws.sdk.kotlin.services.codeguruprofiler.model.ActionGroup = requireNotNull(builder.actionGroup) { "A non-null value must be provided for actionGroup" }
    /**
     * A list ARNs for the roles and users you want to grant access to the profiling group. Wildcards are not are supported in the ARNs.
     */
    public val principals: List<String> = requireNotNull(builder.principals) { "A non-null value must be provided for principals" }
    /**
     * The name of the profiling group to grant access to.
     */
    public val profilingGroupName: kotlin.String = requireNotNull(builder.profilingGroupName) { "A non-null value must be provided for profilingGroupName" }
    /**
     * A universally unique identifier (UUID) for the revision of the policy you are adding to the profiling group. Do not specify this when you add permissions to a profiling group for the first time. If a policy already exists on the profiling group, you must specify the `revisionId`.
     */
    public val revisionId: kotlin.String? = builder.revisionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.PutPermissionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutPermissionRequest(")
        append("actionGroup=$actionGroup,")
        append("principals=$principals,")
        append("profilingGroupName=$profilingGroupName,")
        append("revisionId=$revisionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionGroup.hashCode()
        result = 31 * result + (principals.hashCode())
        result = 31 * result + (profilingGroupName.hashCode())
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutPermissionRequest

        if (actionGroup != other.actionGroup) return false
        if (principals != other.principals) return false
        if (profilingGroupName != other.profilingGroupName) return false
        if (revisionId != other.revisionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.PutPermissionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies an action group that contains permissions to add to a profiling group resource. One action group is supported, `agentPermissions`, which grants permission to perform actions required by the profiling agent, `ConfigureAgent` and `PostAgentProfile` permissions.
         */
        public var actionGroup: aws.sdk.kotlin.services.codeguruprofiler.model.ActionGroup? = null
        /**
         * A list ARNs for the roles and users you want to grant access to the profiling group. Wildcards are not are supported in the ARNs.
         */
        public var principals: List<String>? = null
        /**
         * The name of the profiling group to grant access to.
         */
        public var profilingGroupName: kotlin.String? = null
        /**
         * A universally unique identifier (UUID) for the revision of the policy you are adding to the profiling group. Do not specify this when you add permissions to a profiling group for the first time. If a policy already exists on the profiling group, you must specify the `revisionId`.
         */
        public var revisionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.PutPermissionRequest) : this() {
            this.actionGroup = x.actionGroup
            this.principals = x.principals
            this.profilingGroupName = x.profilingGroupName
            this.revisionId = x.revisionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.PutPermissionRequest = PutPermissionRequest(this)

        internal fun correctErrors(): Builder {
            if (actionGroup == null) actionGroup = ActionGroup.SdkUnknown("no value provided")
            if (principals == null) principals = emptyList()
            if (profilingGroupName == null) profilingGroupName = ""
            return this
        }
    }
}
