// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.codeguruprofiler.auth.CodeGuruProfilerAuthSchemeProvider
import aws.sdk.kotlin.services.codeguruprofiler.auth.DefaultCodeGuruProfilerAuthSchemeProvider
import aws.sdk.kotlin.services.codeguruprofiler.endpoints.CodeGuruProfilerEndpointParameters
import aws.sdk.kotlin.services.codeguruprofiler.endpoints.CodeGuruProfilerEndpointProvider
import aws.sdk.kotlin.services.codeguruprofiler.endpoints.DefaultCodeGuruProfilerEndpointProvider
import aws.sdk.kotlin.services.codeguruprofiler.model.AddNotificationChannelsRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.AddNotificationChannelsResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.BatchGetFrameMetricDataRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.BatchGetFrameMetricDataResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.ConfigureAgentRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.ConfigureAgentResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.CreateProfilingGroupRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.CreateProfilingGroupResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.DeleteProfilingGroupRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.DeleteProfilingGroupResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.DescribeProfilingGroupRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.DescribeProfilingGroupResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.GetNotificationConfigurationRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.GetNotificationConfigurationResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.GetPolicyRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.GetPolicyResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.GetProfileRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.GetProfileResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.GetRecommendationsRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.GetRecommendationsResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.ListFindingsReportsRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.ListFindingsReportsResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.ListProfileTimesRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.ListProfileTimesResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.ListProfilingGroupsRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.ListProfilingGroupsResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.PostAgentProfileRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.PostAgentProfileResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.PutPermissionRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.PutPermissionResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.RemoveNotificationChannelRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.RemoveNotificationChannelResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.RemovePermissionRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.RemovePermissionResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.SubmitFeedbackRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.SubmitFeedbackResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.TagResourceRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.TagResourceResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.UntagResourceRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.UntagResourceResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.UpdateProfilingGroupRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.UpdateProfilingGroupResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "CodeGuruProfiler"
public const val SdkVersion: String = "1.5.52"
public const val ServiceApiVersion: String = "2019-07-18"

/**
 * This section provides documentation for the Amazon CodeGuru Profiler API operations.
 *
 *  Amazon CodeGuru Profiler collects runtime performance data from your live applications, and provides recommendations that can help you fine-tune your application performance. Using machine learning algorithms, CodeGuru Profiler can help you find your most expensive lines of code and suggest ways you can improve efficiency and remove CPU bottlenecks.
 *
 *  Amazon CodeGuru Profiler provides different visualizations of profiling data to help you identify what code is running on the CPU, see how much time is consumed, and suggest ways to reduce CPU utilization.
 *
 * Amazon CodeGuru Profiler currently supports applications written in all Java virtual machine (JVM) languages and Python. While CodeGuru Profiler supports both visualizations and recommendations for applications written in Java, it can also generate visualizations and a subset of recommendations for applications written in other JVM languages and Python.
 *
 *  For more information, see [What is Amazon CodeGuru Profiler](https://docs.aws.amazon.com/codeguru/latest/profiler-ug/what-is-codeguru-profiler.html) in the *Amazon CodeGuru Profiler User Guide*.
 */
public interface CodeGuruProfilerClient : SdkClient {
    /**
     * CodeGuruProfilerClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CodeGuruProfilerClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "CodeGuruProfiler",
                "CODEGURUPROFILER",
                "codeguruprofiler",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CodeGuruProfilerClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CodeGuruProfilerClient = DefaultCodeGuruProfilerClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: CodeGuruProfilerEndpointProvider = builder.endpointProvider ?: DefaultCodeGuruProfilerEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: CodeGuruProfilerAuthSchemeProvider = builder.authSchemeProvider ?: DefaultCodeGuruProfilerAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "CodeGuruProfiler"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: CodeGuruProfilerEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: CodeGuruProfilerAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Add up to 2 anomaly notifications channels for a profiling group.
     */
    public suspend fun addNotificationChannels(input: AddNotificationChannelsRequest): AddNotificationChannelsResponse

    /**
     * Returns the time series of values for a requested list of frame metrics from a time period.
     */
    public suspend fun batchGetFrameMetricData(input: BatchGetFrameMetricDataRequest): BatchGetFrameMetricDataResponse

    /**
     * Used by profiler agents to report their current state and to receive remote configuration updates. For example, `ConfigureAgent` can be used to tell an agent whether to profile or not and for how long to return profiling data.
     */
    public suspend fun configureAgent(input: ConfigureAgentRequest): ConfigureAgentResponse

    /**
     * Creates a profiling group.
     */
    public suspend fun createProfilingGroup(input: CreateProfilingGroupRequest): CreateProfilingGroupResponse

    /**
     * Deletes a profiling group.
     */
    public suspend fun deleteProfilingGroup(input: DeleteProfilingGroupRequest): DeleteProfilingGroupResponse

    /**
     * Returns a `ProfilingGroupDescription`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html) object that contains information about the requested profiling group.
     */
    public suspend fun describeProfilingGroup(input: DescribeProfilingGroupRequest): DescribeProfilingGroupResponse

    /**
     * Returns a list of `FindingsReportSummary`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html) objects that contain analysis results for all profiling groups in your AWS account.
     */
    public suspend fun getFindingsReportAccountSummary(input: GetFindingsReportAccountSummaryRequest = GetFindingsReportAccountSummaryRequest { }): GetFindingsReportAccountSummaryResponse

    /**
     * Get the current configuration for anomaly notifications for a profiling group.
     */
    public suspend fun getNotificationConfiguration(input: GetNotificationConfigurationRequest): GetNotificationConfigurationResponse

    /**
     * Returns the JSON-formatted resource-based policy on a profiling group.
     */
    public suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse

    /**
     * Gets the aggregated profile of a profiling group for a specified time range. Amazon CodeGuru Profiler collects posted agent profiles for a profiling group into aggregated profiles.
     *
     *  Because aggregated profiles expire over time `GetProfile` is not idempotent.
     *
     *  Specify the time range for the requested aggregated profile using 1 or 2 of the following parameters: `startTime`, `endTime`, `period`. The maximum time range allowed is 7 days. If you specify all 3 parameters, an exception is thrown. If you specify only `period`, the latest aggregated profile is returned.
     *
     *  Aggregated profiles are available with aggregation periods of 5 minutes, 1 hour, and 1 day, aligned to UTC. The aggregation period of an aggregated profile determines how long it is retained. For more information, see `AggregatedProfileTime`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html). The aggregated profile's aggregation period determines how long it is retained by CodeGuru Profiler.
     * +  If the aggregation period is 5 minutes, the aggregated profile is retained for 15 days.
     * +  If the aggregation period is 1 hour, the aggregated profile is retained for 60 days.
     * +  If the aggregation period is 1 day, the aggregated profile is retained for 3 years.
     *
     * There are two use cases for calling `GetProfile`.
     * +  If you want to return an aggregated profile that already exists, use `ListProfileTimes`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ListProfileTimes.html) to view the time ranges of existing aggregated profiles. Use them in a `GetProfile` request to return a specific, existing aggregated profile.
     * +  If you want to return an aggregated profile for a time range that doesn't align with an existing aggregated profile, then CodeGuru Profiler makes a best effort to combine existing aggregated profiles from the requested time range and return them as one aggregated profile.  If aggregated profiles do not exist for the full time range requested, then aggregated profiles for a smaller time range are returned. For example, if the requested time range is from 00:00 to 00:20, and the existing aggregated profiles are from 00:15 and 00:25, then the aggregated profiles from 00:15 to 00:20 are returned.
     */
    public suspend fun getProfile(input: GetProfileRequest): GetProfileResponse

    /**
     * Returns a list of `Recommendation`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Recommendation.html) objects that contain recommendations for a profiling group for a given time period. A list of `Anomaly`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Anomaly.html) objects that contains details about anomalies detected in the profiling group for the same time period is also returned.
     */
    public suspend fun getRecommendations(input: GetRecommendationsRequest): GetRecommendationsResponse

    /**
     * List the available reports for a given profiling group and time range.
     */
    public suspend fun listFindingsReports(input: ListFindingsReportsRequest): ListFindingsReportsResponse

    /**
     * Lists the start times of the available aggregated profiles of a profiling group for an aggregation period within the specified time range.
     */
    public suspend fun listProfileTimes(input: ListProfileTimesRequest): ListProfileTimesResponse

    /**
     * Returns a list of profiling groups. The profiling groups are returned as `ProfilingGroupDescription`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html) objects.
     */
    public suspend fun listProfilingGroups(input: ListProfilingGroupsRequest = ListProfilingGroupsRequest { }): ListProfilingGroupsResponse

    /**
     * Returns a list of the tags that are assigned to a specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Submits profiling data to an aggregated profile of a profiling group. To get an aggregated profile that is created with this profiling data, use `GetProfile`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetProfile.html).
     */
    public suspend fun postAgentProfile(input: PostAgentProfileRequest): PostAgentProfileResponse

    /**
     * Adds permissions to a profiling group's resource-based policy that are provided using an action group. If a profiling group doesn't have a resource-based policy, one is created for it using the permissions in the action group and the roles and users in the `principals` parameter.
     *
     *  The one supported action group that can be added is `agentPermission` which grants `ConfigureAgent` and `PostAgent` permissions. For more information, see [Resource-based policies in CodeGuru Profiler](https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html) in the *Amazon CodeGuru Profiler User Guide*, `ConfigureAgent`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html), and `PostAgentProfile`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html).
     *
     *  The first time you call `PutPermission` on a profiling group, do not specify a `revisionId` because it doesn't have a resource-based policy. Subsequent calls must provide a `revisionId` to specify which revision of the resource-based policy to add the permissions to.
     *
     *  The response contains the profiling group's JSON-formatted resource policy.
     */
    public suspend fun putPermission(input: PutPermissionRequest): PutPermissionResponse

    /**
     * Remove one anomaly notifications channel for a profiling group.
     */
    public suspend fun removeNotificationChannel(input: RemoveNotificationChannelRequest): RemoveNotificationChannelResponse

    /**
     * Removes permissions from a profiling group's resource-based policy that are provided using an action group. The one supported action group that can be removed is `agentPermission` which grants `ConfigureAgent` and `PostAgent` permissions. For more information, see [Resource-based policies in CodeGuru Profiler](https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html) in the *Amazon CodeGuru Profiler User Guide*, `ConfigureAgent`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html), and `PostAgentProfile`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html).
     */
    public suspend fun removePermission(input: RemovePermissionRequest): RemovePermissionResponse

    /**
     * Sends feedback to CodeGuru Profiler about whether the anomaly detected by the analysis is useful or not.
     */
    public suspend fun submitFeedback(input: SubmitFeedbackRequest): SubmitFeedbackResponse

    /**
     * Use to assign one or more tags to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Use to remove one or more tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a profiling group.
     */
    public suspend fun updateProfilingGroup(input: UpdateProfilingGroupRequest): UpdateProfilingGroupResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CodeGuruProfilerClient.withConfig(block: CodeGuruProfilerClient.Config.Builder.() -> Unit): CodeGuruProfilerClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCodeGuruProfilerClient(newConfig)
}

/**
 * Add up to 2 anomaly notifications channels for a profiling group.
 */
public suspend inline fun CodeGuruProfilerClient.addNotificationChannels(crossinline block: AddNotificationChannelsRequest.Builder.() -> Unit): AddNotificationChannelsResponse = addNotificationChannels(AddNotificationChannelsRequest.Builder().apply(block).build())

/**
 * Returns the time series of values for a requested list of frame metrics from a time period.
 */
public suspend inline fun CodeGuruProfilerClient.batchGetFrameMetricData(crossinline block: BatchGetFrameMetricDataRequest.Builder.() -> Unit): BatchGetFrameMetricDataResponse = batchGetFrameMetricData(BatchGetFrameMetricDataRequest.Builder().apply(block).build())

/**
 * Used by profiler agents to report their current state and to receive remote configuration updates. For example, `ConfigureAgent` can be used to tell an agent whether to profile or not and for how long to return profiling data.
 */
public suspend inline fun CodeGuruProfilerClient.configureAgent(crossinline block: ConfigureAgentRequest.Builder.() -> Unit): ConfigureAgentResponse = configureAgent(ConfigureAgentRequest.Builder().apply(block).build())

/**
 * Creates a profiling group.
 */
public suspend inline fun CodeGuruProfilerClient.createProfilingGroup(crossinline block: CreateProfilingGroupRequest.Builder.() -> Unit): CreateProfilingGroupResponse = createProfilingGroup(CreateProfilingGroupRequest.Builder().apply(block).build())

/**
 * Deletes a profiling group.
 */
public suspend inline fun CodeGuruProfilerClient.deleteProfilingGroup(crossinline block: DeleteProfilingGroupRequest.Builder.() -> Unit): DeleteProfilingGroupResponse = deleteProfilingGroup(DeleteProfilingGroupRequest.Builder().apply(block).build())

/**
 * Returns a `ProfilingGroupDescription`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html) object that contains information about the requested profiling group.
 */
public suspend inline fun CodeGuruProfilerClient.describeProfilingGroup(crossinline block: DescribeProfilingGroupRequest.Builder.() -> Unit): DescribeProfilingGroupResponse = describeProfilingGroup(DescribeProfilingGroupRequest.Builder().apply(block).build())

/**
 * Returns a list of `FindingsReportSummary`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html) objects that contain analysis results for all profiling groups in your AWS account.
 */
public suspend inline fun CodeGuruProfilerClient.getFindingsReportAccountSummary(crossinline block: GetFindingsReportAccountSummaryRequest.Builder.() -> Unit): GetFindingsReportAccountSummaryResponse = getFindingsReportAccountSummary(GetFindingsReportAccountSummaryRequest.Builder().apply(block).build())

/**
 * Get the current configuration for anomaly notifications for a profiling group.
 */
public suspend inline fun CodeGuruProfilerClient.getNotificationConfiguration(crossinline block: GetNotificationConfigurationRequest.Builder.() -> Unit): GetNotificationConfigurationResponse = getNotificationConfiguration(GetNotificationConfigurationRequest.Builder().apply(block).build())

/**
 * Returns the JSON-formatted resource-based policy on a profiling group.
 */
public suspend inline fun CodeGuruProfilerClient.getPolicy(crossinline block: GetPolicyRequest.Builder.() -> Unit): GetPolicyResponse = getPolicy(GetPolicyRequest.Builder().apply(block).build())

/**
 * Gets the aggregated profile of a profiling group for a specified time range. Amazon CodeGuru Profiler collects posted agent profiles for a profiling group into aggregated profiles.
 *
 *  Because aggregated profiles expire over time `GetProfile` is not idempotent.
 *
 *  Specify the time range for the requested aggregated profile using 1 or 2 of the following parameters: `startTime`, `endTime`, `period`. The maximum time range allowed is 7 days. If you specify all 3 parameters, an exception is thrown. If you specify only `period`, the latest aggregated profile is returned.
 *
 *  Aggregated profiles are available with aggregation periods of 5 minutes, 1 hour, and 1 day, aligned to UTC. The aggregation period of an aggregated profile determines how long it is retained. For more information, see `AggregatedProfileTime`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html). The aggregated profile's aggregation period determines how long it is retained by CodeGuru Profiler.
 * +  If the aggregation period is 5 minutes, the aggregated profile is retained for 15 days.
 * +  If the aggregation period is 1 hour, the aggregated profile is retained for 60 days.
 * +  If the aggregation period is 1 day, the aggregated profile is retained for 3 years.
 *
 * There are two use cases for calling `GetProfile`.
 * +  If you want to return an aggregated profile that already exists, use `ListProfileTimes`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ListProfileTimes.html) to view the time ranges of existing aggregated profiles. Use them in a `GetProfile` request to return a specific, existing aggregated profile.
 * +  If you want to return an aggregated profile for a time range that doesn't align with an existing aggregated profile, then CodeGuru Profiler makes a best effort to combine existing aggregated profiles from the requested time range and return them as one aggregated profile.  If aggregated profiles do not exist for the full time range requested, then aggregated profiles for a smaller time range are returned. For example, if the requested time range is from 00:00 to 00:20, and the existing aggregated profiles are from 00:15 and 00:25, then the aggregated profiles from 00:15 to 00:20 are returned.
 */
public suspend inline fun CodeGuruProfilerClient.getProfile(crossinline block: GetProfileRequest.Builder.() -> Unit): GetProfileResponse = getProfile(GetProfileRequest.Builder().apply(block).build())

/**
 * Returns a list of `Recommendation`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Recommendation.html) objects that contain recommendations for a profiling group for a given time period. A list of `Anomaly`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Anomaly.html) objects that contains details about anomalies detected in the profiling group for the same time period is also returned.
 */
public suspend inline fun CodeGuruProfilerClient.getRecommendations(crossinline block: GetRecommendationsRequest.Builder.() -> Unit): GetRecommendationsResponse = getRecommendations(GetRecommendationsRequest.Builder().apply(block).build())

/**
 * List the available reports for a given profiling group and time range.
 */
public suspend inline fun CodeGuruProfilerClient.listFindingsReports(crossinline block: ListFindingsReportsRequest.Builder.() -> Unit): ListFindingsReportsResponse = listFindingsReports(ListFindingsReportsRequest.Builder().apply(block).build())

/**
 * Lists the start times of the available aggregated profiles of a profiling group for an aggregation period within the specified time range.
 */
public suspend inline fun CodeGuruProfilerClient.listProfileTimes(crossinline block: ListProfileTimesRequest.Builder.() -> Unit): ListProfileTimesResponse = listProfileTimes(ListProfileTimesRequest.Builder().apply(block).build())

/**
 * Returns a list of profiling groups. The profiling groups are returned as `ProfilingGroupDescription`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html) objects.
 */
public suspend inline fun CodeGuruProfilerClient.listProfilingGroups(crossinline block: ListProfilingGroupsRequest.Builder.() -> Unit): ListProfilingGroupsResponse = listProfilingGroups(ListProfilingGroupsRequest.Builder().apply(block).build())

/**
 * Returns a list of the tags that are assigned to a specified resource.
 */
public suspend inline fun CodeGuruProfilerClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Submits profiling data to an aggregated profile of a profiling group. To get an aggregated profile that is created with this profiling data, use `GetProfile`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetProfile.html).
 */
public suspend inline fun CodeGuruProfilerClient.postAgentProfile(crossinline block: PostAgentProfileRequest.Builder.() -> Unit): PostAgentProfileResponse = postAgentProfile(PostAgentProfileRequest.Builder().apply(block).build())

/**
 * Adds permissions to a profiling group's resource-based policy that are provided using an action group. If a profiling group doesn't have a resource-based policy, one is created for it using the permissions in the action group and the roles and users in the `principals` parameter.
 *
 *  The one supported action group that can be added is `agentPermission` which grants `ConfigureAgent` and `PostAgent` permissions. For more information, see [Resource-based policies in CodeGuru Profiler](https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html) in the *Amazon CodeGuru Profiler User Guide*, `ConfigureAgent`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html), and `PostAgentProfile`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html).
 *
 *  The first time you call `PutPermission` on a profiling group, do not specify a `revisionId` because it doesn't have a resource-based policy. Subsequent calls must provide a `revisionId` to specify which revision of the resource-based policy to add the permissions to.
 *
 *  The response contains the profiling group's JSON-formatted resource policy.
 */
public suspend inline fun CodeGuruProfilerClient.putPermission(crossinline block: PutPermissionRequest.Builder.() -> Unit): PutPermissionResponse = putPermission(PutPermissionRequest.Builder().apply(block).build())

/**
 * Remove one anomaly notifications channel for a profiling group.
 */
public suspend inline fun CodeGuruProfilerClient.removeNotificationChannel(crossinline block: RemoveNotificationChannelRequest.Builder.() -> Unit): RemoveNotificationChannelResponse = removeNotificationChannel(RemoveNotificationChannelRequest.Builder().apply(block).build())

/**
 * Removes permissions from a profiling group's resource-based policy that are provided using an action group. The one supported action group that can be removed is `agentPermission` which grants `ConfigureAgent` and `PostAgent` permissions. For more information, see [Resource-based policies in CodeGuru Profiler](https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html) in the *Amazon CodeGuru Profiler User Guide*, `ConfigureAgent`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html), and `PostAgentProfile`[](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html).
 */
public suspend inline fun CodeGuruProfilerClient.removePermission(crossinline block: RemovePermissionRequest.Builder.() -> Unit): RemovePermissionResponse = removePermission(RemovePermissionRequest.Builder().apply(block).build())

/**
 * Sends feedback to CodeGuru Profiler about whether the anomaly detected by the analysis is useful or not.
 */
public suspend inline fun CodeGuruProfilerClient.submitFeedback(crossinline block: SubmitFeedbackRequest.Builder.() -> Unit): SubmitFeedbackResponse = submitFeedback(SubmitFeedbackRequest.Builder().apply(block).build())

/**
 * Use to assign one or more tags to a resource.
 */
public suspend inline fun CodeGuruProfilerClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Use to remove one or more tags from a resource.
 */
public suspend inline fun CodeGuruProfilerClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a profiling group.
 */
public suspend inline fun CodeGuruProfilerClient.updateProfilingGroup(crossinline block: UpdateProfilingGroupRequest.Builder.() -> Unit): UpdateProfilingGroupResponse = updateProfilingGroup(UpdateProfilingGroupRequest.Builder().apply(block).build())
