// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.paginators

import aws.sdk.kotlin.services.codeguruprofiler.CodeGuruProfilerClient
import aws.sdk.kotlin.services.codeguruprofiler.model.GetFindingsReportAccountSummaryRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.GetFindingsReportAccountSummaryResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.ListFindingsReportsRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.ListFindingsReportsResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.ListProfileTimesRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.ListProfileTimesResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.ListProfilingGroupsRequest
import aws.sdk.kotlin.services.codeguruprofiler.model.ListProfilingGroupsResponse
import aws.sdk.kotlin.services.codeguruprofiler.model.ProfileTime
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetFindingsReportAccountSummaryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetFindingsReportAccountSummaryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFindingsReportAccountSummaryResponse]
 */
public fun CodeGuruProfilerClient.getFindingsReportAccountSummaryPaginated(initialRequest: GetFindingsReportAccountSummaryRequest = GetFindingsReportAccountSummaryRequest { }): Flow<GetFindingsReportAccountSummaryResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getFindingsReportAccountSummaryPaginated.getFindingsReportAccountSummary(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetFindingsReportAccountSummaryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFindingsReportAccountSummaryResponse]
 */
public fun CodeGuruProfilerClient.getFindingsReportAccountSummaryPaginated(block: GetFindingsReportAccountSummaryRequest.Builder.() -> Unit): Flow<GetFindingsReportAccountSummaryResponse> =
    getFindingsReportAccountSummaryPaginated(GetFindingsReportAccountSummaryRequest.Builder().apply(block).build())

/**
 * Paginate over [ListFindingsReportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFindingsReportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingsReportsResponse]
 */
public fun CodeGuruProfilerClient.listFindingsReportsPaginated(initialRequest: ListFindingsReportsRequest): Flow<ListFindingsReportsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFindingsReportsPaginated.listFindingsReports(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFindingsReportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingsReportsResponse]
 */
public fun CodeGuruProfilerClient.listFindingsReportsPaginated(block: ListFindingsReportsRequest.Builder.() -> Unit): Flow<ListFindingsReportsResponse> =
    listFindingsReportsPaginated(ListFindingsReportsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListProfileTimesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProfileTimesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProfileTimesResponse]
 */
public fun CodeGuruProfilerClient.listProfileTimesPaginated(initialRequest: ListProfileTimesRequest): Flow<ListProfileTimesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProfileTimesPaginated.listProfileTimes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProfileTimesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProfileTimesResponse]
 */
public fun CodeGuruProfilerClient.listProfileTimesPaginated(block: ListProfileTimesRequest.Builder.() -> Unit): Flow<ListProfileTimesResponse> =
    listProfileTimesPaginated(ListProfileTimesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProfileTimesPaginated]
 * to access the nested member [ProfileTime]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProfileTime]
 */
@JvmName("listProfileTimesResponseProfileTime")
public fun Flow<ListProfileTimesResponse>.profileTimes(): Flow<ProfileTime> =
    transform() { response ->
        response.profileTimes?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListProfilingGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProfilingGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProfilingGroupsResponse]
 */
public fun CodeGuruProfilerClient.listProfilingGroupsPaginated(initialRequest: ListProfilingGroupsRequest = ListProfilingGroupsRequest { }): Flow<ListProfilingGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProfilingGroupsPaginated.listProfilingGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProfilingGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProfilingGroupsResponse]
 */
public fun CodeGuruProfilerClient.listProfilingGroupsPaginated(block: ListProfilingGroupsRequest.Builder.() -> Unit): Flow<ListProfilingGroupsResponse> =
    listProfilingGroupsPaginated(ListProfilingGroupsRequest.Builder().apply(block).build())
